/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.eclipse.ui.IWorkbenchPart;
import org.simantics.db.management.ISessionContext;

/**
 * @author Tuukka Lehtonen
 */
public interface SessionContextInputSource {
    /**
     * @param ctx the session context to read the input from. May be
     *        <code>null</code> if there is no session.
     * @return the input object of a graph explorer. To indicate no input,
     *         use {@link GraphExplorerConstants#EMPTY_INPUT}. Never return
     *         <code>null</code>.
     */
    Object get(ISessionContext ctx);
    IWorkbenchPart getProvider();
    
}
