/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.db.request.Read;

public class L0StringModifier implements Modifier {

	final private RequestProcessor processor;
	final private Resource resource;

	public L0StringModifier(RequestProcessor processor, Resource resource) {
		this.processor = processor;
		this.resource = resource;
	}

	@Override
	public String getValue() {
		try {
			return processor.syncRequest(new PossibleAdapter<String>(resource, String.class));
		} catch (DatabaseException e) {
			ErrorLogger.defaultLogError(e);
			return null;
		}
	}

	@Override
	public String isValid(final String label) {
		try {
			return processor.syncRequest(new Read<String>() {
				@Override
				public String perform(ReadGraph graph) throws DatabaseException {
					StringModifier modifier = graph.adapt(resource, StringModifier.class);
					return modifier.isValid(label);
				}
			});
		} catch (DatabaseException e) {
			ErrorLogger.defaultLogError(e);
			return e.getMessage();
		}
	}

	@Override
	public void modify(final String label) {
		try {
			processor.syncRequest(new WriteRequest() {
				@Override
				public void perform(WriteGraph graph) throws DatabaseException {
					StringModifier modifier = graph.adapt(resource, StringModifier.class);
					modifier.modify(graph, label);
				}
			});
		} catch (DatabaseException e) {
			ErrorLogger.defaultLogError(e);
		}
	}

}
