/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import org.simantics.browsing.ui.common.modifiers.EnumeratedValue;
import org.simantics.browsing.ui.common.modifiers.Enumeration;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 */
public class GetEnumeration extends ResourceRead<Enumeration<Resource>> {

    public GetEnumeration(Resource resource) {
        super(resource);
    }

    @Override
    public Enumeration<Resource> perform(ReadGraph graph) throws DatabaseException {
        return enumerate(graph, resource);
    }

    public static Enumeration<Resource> enumerate(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance(graph);
        Set<Resource> types = graph.getTypes(resource);

        // FIXME: this is a hack to make boolean values editable through a combo-box like other enumerations
        if (types.contains(l0.Boolean) || types.contains(l0.BooleanArray)) {
            List<EnumeratedValue<Resource>> values = new ArrayList<EnumeratedValue<Resource>>(2);
            values.add(new EnumeratedValue<Resource>(Boolean.FALSE.toString(), l0.False));
            values.add(new EnumeratedValue<Resource>(Boolean.TRUE.toString(), l0.True));
            return new Enumeration<Resource>(values);
        } else {
            for (Resource type : types) {
                if (graph.hasStatement(type, l0.Enumeration, type)) {
                    Collection<Resource> values = graph.getObjects(type, l0.ConsistsOf);
                    List<EnumeratedValue<Resource>> result = new ArrayList<EnumeratedValue<Resource>>(values.size());
                    for (Resource value : values) {
                        result.add(new EnumeratedValue<Resource>(safeName(graph, value), value));
                    }
                    return new Enumeration<Resource>(result);
                }
            }
        }
        return null;
    }

    private static String safeName(ReadGraph graph, Resource value) throws DatabaseException {
        return graph.syncRequest(new NameRequest(value)); 
    }

    public static class NameRequest extends ResourceRead<String> {
        public NameRequest(Resource resource) {
            super(resource);
        }
        @Override
        public String perform(ReadGraph graph) throws DatabaseException {
            try {
                return graph.adapt(resource, String.class);
            } catch (AdaptionException e) {
                return NameUtils.getSafeName(graph, resource);
            }
        }
    }

}
