/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.Collection;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointKey;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointContributionFactory;
import org.simantics.browsing.ui.content.ViewpointFactory;

public class ContributionViewpointFactory implements ViewpointFactory {

    final private String name;
    final private Collection<ViewpointContributionFactory> contributions;
    
    public ContributionViewpointFactory(String name, Collection<ViewpointContributionFactory> contributions) {
        this.name = name;
        this.contributions = contributions;
    }
    
    @Override
    public Viewpoint create(PrimitiveQueryUpdater updater,
            NodeContext context, ViewpointKey key) {

        assert(updater != null);
        assert(context != null);

        return new ContributionViewpoint(contributions);
        
    }
    
    @Override
    public String toString() {
        return name;
    }

}
