/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.property;

import java.util.Collection;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.NodeContextUtil;
import org.simantics.browsing.ui.common.property.IArrayProperty;
import org.simantics.browsing.ui.common.property.IProperty;
import org.simantics.utils.datastructures.slice.SliceUtil;
import org.simantics.utils.datastructures.slice.Sliceable;
import org.simantics.utils.datastructures.slice.ValueRange;

public class PropertyUtil {
    public static <T extends IProperty> NodeContext[] getChildren(IProperty property) {
        return PropertyUtil.getChildren(property, false);
    }

    public static <T extends IProperty> NodeContext[] getChildren(IProperty property, boolean createOneChild) {
        if (!(property instanceof IArrayProperty)) {
            return NodeContext.NONE;
        }
        IArrayProperty array = (IArrayProperty)property;
        ValueRange range = array.getRange();
        if (range.size() < 1 || !createOneChild && range.size() < 2) {
            return NodeContext.NONE;
        }
        Collection<IArrayProperty> children = PropertyUtil.subnodify(array, range.start(), range.size());
        return NodeContextUtil.toContextsWithInput(children);
    }

    public static Boolean hasChildren(IProperty property) {
        if (!(property instanceof IArrayProperty)) {
            return Boolean.FALSE;
        }
        IArrayProperty array = (IArrayProperty)property;
        ValueRange range = array.getRange();
        return range.size() < 2;
    }

    public static <T extends Sliceable<T>> Collection<T> subnodify(Sliceable<T> prop, int rangeStart, int rangeSize) {
        return SliceUtil.subnodify(prop, (int)rangeStart, (int)rangeSize);
    }

    public static <T> Collection<T> subnodify(Object p, int rangeStart, int rangeSize, int pow10OfItemsPerLevel) {
        return SliceUtil.subnodify((Object)p, (int)rangeStart, (int)rangeSize, (int)pow10OfItemsPerLevel);
    }

    public static enum ValueType {
        NoValue,
        BooleanValue,
        ByteValue,
        IntegerValue,
        LongValue,
        FloatValue,
        DoubleValue,
        StringValue,
        UnrecognizedValue;


        public static ValueType convert(Object obj) {
            if (obj == null) {
                return NoValue;
            }
            if (obj.getClass() == Boolean.class) {
                return BooleanValue;
            }
            if (obj.getClass() == boolean[].class) {
                return BooleanValue;
            }
            if (obj.getClass() == Byte.class) {
                return ByteValue;
            }
            if (obj.getClass() == byte[].class) {
                return ByteValue;
            }
            if (obj.getClass() == Integer.class) {
                return IntegerValue;
            }
            if (obj.getClass() == int[].class) {
                return IntegerValue;
            }
            if (obj.getClass() == Long.class) {
                return LongValue;
            }
            if (obj.getClass() == long[].class) {
                return LongValue;
            }
            if (obj.getClass() == Float.class) {
                return FloatValue;
            }
            if (obj.getClass() == float[].class) {
                return FloatValue;
            }
            if (obj.getClass() == Double.class) {
                return DoubleValue;
            }
            if (obj.getClass() == double[].class) {
                return DoubleValue;
            }
            if (obj.getClass() == String.class) {
                return StringValue;
            }
            if (obj.getClass() == String[].class) {
                return StringValue;
            }
            return UnrecognizedValue;
        }

        public static String toString(ValueType type) {
            switch (type) {
                case NoValue: {
                    return "no value";
                }
                case BooleanValue: {
                    return "boolean";
                }
                case ByteValue: {
                    return "byte";
                }
                case DoubleValue: {
                    return "double";
                }
                case FloatValue: {
                    return "float";
                }
                case IntegerValue: {
                    return "int32";
                }
                case LongValue: {
                    return "int64";
                }
                case StringValue: {
                    return "string";
                }
                case UnrecognizedValue: {
                    return "unknown value";
                }
            }
            throw new IllegalArgumentException("unrecognized value type: " + (Object)((Object)type));
        }
    }
}

