/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.viewpoints;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.content.Viewpoint;

public class LazyContainerViewpoint implements Viewpoint {

    private NodeContext[] children = Viewpoint.PENDING_CHILDREN;
    private Boolean        hasChildren = Viewpoint.PENDING_HAS_CHILDREN;

    public LazyContainerViewpoint() {
    }

    public LazyContainerViewpoint(NodeContext[] children) {
        this.children = children;
        this.hasChildren = children.length > 0;
    }

    public void setChildren(PrimitiveQueryUpdater updater, NodeContext[] children) {
        for(NodeContext c : children) updater.incRef(c);
        for(NodeContext c : this.children) updater.decRef(c);
        this.children = children;
    }

    public void setHasChildren(Boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    @Override
    public NodeContext[] getChildren() {
        return children;
    }

    @Override
    public Boolean getHasChildren() {
        return hasChildren;
    }

}
