package org.simantics.browsing.ui.common.state;

import java.io.File;
import java.util.concurrent.CompletableFuture;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.simantics.DatabaseJob;
import org.simantics.browsing.ui.ExplorerState;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.StatePersistor;
import org.simantics.browsing.ui.common.Activator;

/**
 * @author Tuukka Lehtonen
 * @since 1.36.0
 */
public class ExplorerStates {

    public static File explorerStateLocation() {
        return Platform.getStateLocation(Activator.getDefault().getBundle()).toFile();
    }

    public static CompletableFuture<ExplorerState> scheduleRead(NodeContext root, StatePersistor persistor) {
        CompletableFuture<ExplorerState> result = new CompletableFuture<>();
        new ReaderJob(root, persistor, result).schedule();
        return result;
    }

    private static class ReaderJob extends DatabaseJob {

        private NodeContext root;
        private StatePersistor persistor;
        private CompletableFuture<ExplorerState> consumer;

        public ReaderJob(NodeContext root, StatePersistor persistor, CompletableFuture<ExplorerState> consumer) {
            super("Reading previous graph explorer state");
            this.root = root;
            this.persistor = persistor;
            this.consumer = consumer;
        }

        @Override
        protected IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask("Loading persisted data", 1);
                ExplorerState state = persistor.deserialize(explorerStateLocation(), root);
                monitor.worked(1);
                consumer.complete(state);
                return Status.OK_STATUS;
            } finally {
                monitor.done();
            }
        }

    }

}
