/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.property;

import java.util.Comparator;

/**
 * @author Tuukka Lehtonen
 */
public class PropertyComparator implements Comparator<PropertyComparable> {

    public static final PropertyComparator INSTANCE = new PropertyComparator();

    @Override
    public int compare(PropertyComparable o1, PropertyComparable o2) {
        int h1 = o1.propertyHashCode();
        int h2 = o2.propertyHashCode();
        if (h1 != h2) {
            return h1-h2;
        }
        boolean equals = o1.propertyEquals(o2);
        return equals ? 0 : -1;
    }

}