/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import java.util.Collection;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.NodeContext.QueryKey;
import org.simantics.browsing.ui.content.ComparableContext;
import org.simantics.browsing.ui.content.ComparableContextFactory;
import org.simantics.browsing.ui.content.PrunedChildrenResult;

public class DefaultComparableChildrenProcessor extends AbstractNodeQueryProcessor<ComparableContext[]> {

    private ComparableContext[] build(NodeQueryManager manager, NodeContext context, ComparableContextFactory factory) {
        PrunedChildrenResult pruned = manager.query(context, BuiltinKeys.PRUNED_CHILDREN);
        NodeContext[] prunedChildren = pruned.getPrunedChildren();
        return factory.create(manager, context, prunedChildren);
    }

    @Override
    public ComparableContext[] query(NodeQueryManager manager, NodeContext context) {
        Collection<ComparableContextFactory> factories = manager.query(context, BuiltinKeys.COMPARABLE_FACTORIES);
        if(factories.isEmpty())
            return null;

        // TODO: use SelectedComparatorFactory query instead of this "educated guess"
        ComparableContextFactory factory = factories.iterator().next();

        return build(manager, context, factory);
    }

    @Override
    public String toString() {
        return "ComparableProcessor";
    }

    @Override
    public QueryKey<ComparableContext[]> getIdentifier() {
        return BuiltinKeys.COMPARABLE_CHILDREN;
    }

}