/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.node;

/**
 * A tag interface for indicating that a browser node may be considered
 * deletable. It is used by model browser menu extensions to check whether to
 * show the "delete" option to the user or not.
 * 
 * <p>
 * There are several ways of specifying the actual deletion procedure for your
 * nodes.
 * 
 * <ol>
 * <li>To specify your own custom deletion logic, you can make your node
 * implement {@link IDeletableNode}</li>
 * <li>If your nodes are backed by database resources, you can make the nodes
 * adaptable to Resource (which {@link AbstractNode} already is), and make your
 * specific resource type adaptable to {@link Remover} (see <a
 * href="https://www.simantics.org/wiki/index.php/Resource_Adaptation"
 * >instructions</a>)</li>
 * <li>Specify your own Eclipse command framework <code>IHandler</code>, using the
 * org.eclipse.ui.handlers extension point, that is active only for your
 * particular node input. Don't use this method unless you have to.</li>
 * </ol>
 * 
 * @see IDeletableNode
 * @see AbstractNode
 */
public interface IDeletable {
}