/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.imagers;

import java.util.HashMap;
import java.util.Map;

import org.simantics.browsing.ui.content.Imager;

/**
 * @author Antti Villberg
 * 
 */
public class ContainerImager<Image> implements Imager {

    private final Map<String, Image> constants;

    private Image                    theImage;

    public ContainerImager(Map<String, Image> constants, Image image) {
        this.constants = constants;
        this.theImage = image;
    }

    public ContainerImager(Map<String, Image> constants) {
    	this(constants, null);
    }

    public ContainerImager(Image image) {
    	this(new HashMap<String, Image>(), image);
    }

    public ContainerImager() {
    	this(new HashMap<String, Image>(), null);
    }


    public void setImage(String key, Image image) {
        if (key == null)
            theImage = image;
        else
            constants.put(key, image);
    }

    public void setImage(Image image) {
        theImage = image;
    }

    @SuppressWarnings("unchecked")
	@Override
    public Image getImage(String key) {
        if (theImage != null)
            return theImage;
        else
            return constants.get(key);
    }

}
