/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.extension;

import org.simantics.browsing.ui.common.extension.internal.ContributorReferenceBinding;
import org.simantics.browsing.ui.common.extension.internal.LabelerContributorReferenceBinding;
import org.simantics.browsing.ui.content.LabelerFactory;

/**
 * @author Tuukka Lehtonen
 */
public class LabelerContributorBindingExtensionManager extends ContributorBindingExtensionManager<LabelerFactory> {

    private static LabelerContributorBindingExtensionManager INSTANCE;
    
    public static synchronized LabelerContributorBindingExtensionManager getInstance() {
        if (INSTANCE == null)
            INSTANCE = new LabelerContributorBindingExtensionManager();
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }

    @Override
    String getExtensionPointName() {
    	return "labelerBinding";
    }
    
    @Override
    ContributorReferenceBinding<LabelerFactory> createReferenceBinding(double preference, String browseContext, String factoryId) {
    	return new LabelerContributorReferenceBinding(preference, browseContext, factoryId);
    }

}
