/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.extension;

import org.simantics.browsing.ui.common.extension.internal.ContributorReferenceBinding;
import org.simantics.browsing.ui.common.extension.internal.ImageDecoratorContributorReferenceBinding;
import org.simantics.browsing.ui.content.ImageDecoratorFactory;

/**
 * @author Tuukka Lehtonen
 */
public class ImageDecoratorContributorBindingExtensionManager extends ContributorBindingExtensionManager<ImageDecoratorFactory> {

    private static ImageDecoratorContributorBindingExtensionManager INSTANCE;
    
    public static synchronized ImageDecoratorContributorBindingExtensionManager getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ImageDecoratorContributorBindingExtensionManager();
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }

    @Override
    String getExtensionPointName() {
    	return "imageDecoratorBinding";
    }
    
    @Override
    ContributorReferenceBinding<ImageDecoratorFactory> createReferenceBinding(double preference, String browseContext, String factoryId) {
    	return new ImageDecoratorContributorReferenceBinding(preference, browseContext, factoryId);
    }

}
