/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.audit.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.simantics.audit.AuditLogging;
import org.simantics.audit.AuditLoggingException;
import org.simantics.audit.client.AuditLoggingAPIClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLoggingClient {
    private static final String AUDIT_SERVER_ADDRESS = "org.simantics.audit.serverAddress";
    private static final String AUDIT_CLIENT_ID = "org.simantics.audit.clientId";
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLoggingClient.class);
    private static AuditLoggingClient INSTANCE;
    private AuditLoggingAPIClient apiClient;

    private AuditLoggingClient(String clientId, String serverAddress) throws AuditLoggingException {
        this.apiClient = new AuditLoggingAPIClient(clientId, serverAddress);
    }

    private static AuditLoggingClient fromEnv() throws AuditLoggingException {
        return AuditLoggingClient.fromProps(System.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuditLoggingClient fromProps(Map<Object, Object> properties) throws AuditLoggingException {
        if (INSTANCE != null) return INSTANCE;
        Class<AuditLoggingClient> clazz = AuditLoggingClient.class;
        synchronized (AuditLoggingClient.class) {
            if (INSTANCE != null) return INSTANCE;
            String serverAddress = (String)properties.get(AUDIT_SERVER_ADDRESS);
            String clientId = (String)properties.get(AUDIT_CLIENT_ID);
            if (clientId == null || clientId.isEmpty()) {
                clientId = UUID.randomUUID().toString();
            }
            if (serverAddress != null && !serverAddress.isEmpty()) {
                INSTANCE = new AuditLoggingClient(clientId, serverAddress);
            } else {
                LOGGER.warn("No {} system property defined so client not configured", (Object)AUDIT_SERVER_ADDRESS);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static String getUUID() throws AuditLoggingException {
        return AuditLoggingClient.fromEnv().apiClient.getUuid();
    }

    public static void sendLog(List<Object> keyValues) throws AuditLoggingException {
        AuditLoggingClient.commit(AuditLogging.Level.INFO, AuditLoggingClient.toMap(keyValues.toArray()));
    }

    private static Map<String, Object> toMap(Object ... keyValues) {
        if (keyValues.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid amount of arguments! " + Arrays.toString(keyValues));
        }
        HashMap<String, Object> results = new HashMap<String, Object>(keyValues.length / 2);
        int i = 0;
        while (i < keyValues.length) {
            Object key = keyValues[i];
            Object value = keyValues[i + 1];
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Key with index " + i + " is not String");
            }
            results.put((String)key, value);
            i += 2;
        }
        return results;
    }

    public static void sendLog(Map<String, Object> event) throws AuditLoggingException {
        AuditLoggingClient.commit(AuditLogging.Level.INFO, event);
    }

    public static void sendError(Map<String, Object> event) throws AuditLoggingException {
        AuditLoggingClient.commit(AuditLogging.Level.ERROR, event);
    }

    public static void sendError(List<Object> keyValues) throws AuditLoggingException {
        AuditLoggingClient.commit(AuditLogging.Level.ERROR, AuditLoggingClient.toMap(keyValues.toArray()));
    }

    public static void sendTrace(Map<String, Object> event) throws AuditLoggingException {
        AuditLoggingClient.commit(AuditLogging.Level.TRACE, event);
    }

    public static void sendTrace(List<Object> keyValues) throws AuditLoggingException {
        AuditLoggingClient.commit(AuditLogging.Level.TRACE, AuditLoggingClient.toMap(keyValues.toArray()));
    }

    private static void commit(AuditLogging.Level level, Map<String, Object> message) throws AuditLoggingException {
        try {
            AuditLoggingClient client = AuditLoggingClient.fromEnv();
            if (client == null || client.apiClient == null) {
                LOGGER.warn("Audit logging server not configured - printing event to log");
                LOGGER.info(message.toString());
            } else {
                AuditLoggingAPIClient apiClient = client.apiClient;
                switch (level) {
                    case INFO: {
                        apiClient.log(message);
                        break;
                    }
                    case ERROR: {
                        apiClient.error(message);
                        break;
                    }
                    case TRACE: {
                        apiClient.trace(message);
                        break;
                    }
                }
            }
        }
        catch (AuditLoggingException e) {
            LOGGER.error("Could not send audit event {} with level {}", new Object[]{message, level, e});
            AuditLogging.log("local", message);
            throw e;
        }
    }
}

