/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.annotation.ui.internal;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.annotation.ui.Activator;
import org.simantics.db.Resource;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.ui.workbench.dialogs.ResourceSelectionDialog3;
import org.simantics.utils.datastructures.Pair;

public class SaveAnnotationDialog
extends ResourceSelectionDialog3<Resource> {
    private String name = "";

    public SaveAnnotationDialog(Shell shell, Map<Resource, Pair<String, ImageDescriptor>> parameter, String title) {
        super(shell, parameter, title);
    }

    protected IDialogSettings getBaseDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    protected Control createExtendedContentArea(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText("Select a name:");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)l);
        final Text t = new Text(parent, 2048);
        t.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveAnnotationDialog.this.name = t.getText();
                SaveAnnotationDialog.this.validatePage();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)t);
        this.validatePage();
        return super.createExtendedContentArea(parent);
    }

    protected void handleSelected(StructuredSelection selection) {
        super.handleSelected(selection);
        this.validatePage();
    }

    protected void validatePage() {
        StructuredSelection selection = this.getSelectedItems();
        String error = this.validateName(this.name);
        if (error != null) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.ui", error));
        } else if (selection.isEmpty()) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.ui", "No Library selected"));
        } else {
            Resource library = (Resource)selection.getFirstElement();
            try {
                Map children = (Map)Simantics.sync((ReadInterface)new UnescapedChildMapOfResource(library));
                if (children.containsKey(this.name)) {
                    this.updateStatus((IStatus)new Status(4, "org.eclipse.ui", "Name is already in use."));
                } else {
                    this.updateStatus((IStatus)new Status(0, "org.simantics.annotation.ui", ""));
                }
            }
            catch (DatabaseException e) {
                this.updateStatus((IStatus)new Status(4, "org.eclipse.ui", "Failed to check validity of name. See error log.", (Throwable)e));
            }
        }
    }

    protected String validateName(String name) {
        if (name.trim().isEmpty()) {
            return "Name cannot be empty";
        }
        if (name.startsWith(".")) {
            return "Name cannot begin with a dot";
        }
        return null;
    }

    public String getName() {
        return this.name;
    }
}

