/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.annotation.ui.editor;

import org.eclipse.ui.IEditorInput;
import org.simantics.NameLabelUtil;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.features.EditorNamingService2;
import org.simantics.ui.workbench.IEditorNamingService2;
import org.simantics.ui.workbench.IResourceEditorInput;

public class AnnotationTypeEditorNamingService
extends EditorNamingService2
implements IEditorNamingService2 {
    public String getName(ReadGraph graph, String editorId, IEditorInput in) throws DatabaseException {
        if (!(in instanceof IResourceEditorInput)) {
            return "";
        }
        IResourceEditorInput input = (IResourceEditorInput)in;
        Resource r = input.getResource();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource property = graph.getPossibleObject(r, L0.HasRange_Inverse);
        return this.limitedName(graph, NameLabelUtil.modalName((ReadGraph)graph, (Resource)(property != null ? property : r)), (IEditorInput)input);
    }

    public String getToolTipText(ReadGraph graph, String editorId, IEditorInput input) throws DatabaseException {
        return this.getTooltip(graph, editorId, (IResourceEditorInput)input, new StringBuilder()).toString();
    }

    private StringBuilder getTooltip(ReadGraph graph, String editorId, IResourceEditorInput input, StringBuilder sb) throws DatabaseException {
        Resource r;
        Resource model;
        if (input.getResource() != null && (model = (Resource)graph.syncRequest((Read)new PossibleModel(r = input.getResource()))) != null) {
            String uri = graph.getPossibleURI(input.getResource());
            if (uri != null) {
                String modelURI = graph.getPossibleURI(model);
                String path = uri.replace(String.valueOf(modelURI) + "/", "");
                path = path.replaceFirst("/[^/]*$", "/");
                sb.append(URIStringUtils.unescape((String)path));
            }
            sb.append(this.getName(graph, editorId, (IEditorInput)input));
            String modelLabel = NameLabelUtil.modalName((ReadGraph)graph, (Resource)model);
            sb.append(" (").append(modelLabel).append(")");
        }
        return sb;
    }
}

