/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.annotation.ui.internal;

import java.util.Map;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.annotation.ui.Activator;
import org.simantics.db.Resource;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.workbench.dialogs.ResourceSelectionDialog3;
import org.simantics.utils.datastructures.Pair;

/**
 * @author Jani Simomaa <jani.simomaa@semantum.fi>
 */
public class SaveAnnotationDialog extends ResourceSelectionDialog3<Resource> {

	private String name;

	public SaveAnnotationDialog(Shell shell,
			Map<Resource, Pair<String, ImageDescriptor>> parameter, String title) {
		super(shell, parameter, title);
		this.name = "";
	}

	@Override
	protected IDialogSettings getBaseDialogSettings() {
		return Activator.getDefault().getDialogSettings();
	}

	@Override
	protected Control createExtendedContentArea(Composite parent) {
		Label l = new Label(parent, SWT.NONE); 
		l.setText("Select a name:");
		GridDataFactory.fillDefaults().grab(true, false).applyTo(l);
		final Text t = new Text(parent,SWT.BORDER);
		t.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				name = t.getText();
				validatePage();
			}
		});
		GridDataFactory.fillDefaults().grab(true, false).applyTo(t);
		validatePage();
		return super.createExtendedContentArea(parent);
	}

	@Override
	protected void handleSelected(StructuredSelection selection) {
		super.handleSelected(selection);
		validatePage();	
	}

	protected void validatePage() {
		StructuredSelection selection = getSelectedItems();
		String error = validateName(name);
		if (error != null) {
			updateStatus(new Status(Status.ERROR, PlatformUI.PLUGIN_ID, error));
		} else if (selection.isEmpty()) {
			updateStatus(new Status(Status.ERROR, PlatformUI.PLUGIN_ID, "No Library selected"));
		} else {
			// Validate that the name is not in use.
			Resource library = (Resource) selection.getFirstElement();
			try {
				Map<String, Resource> children = Simantics.sync(new UnescapedChildMapOfResource(library));
				if (children.containsKey(name)) {
					updateStatus(new Status(Status.ERROR, PlatformUI.PLUGIN_ID, "Name is already in use."));
				} else {
					updateStatus(new Status(Status.OK, Activator.PLUGIN_ID, ""));
				}
			} catch (DatabaseException e) {
				updateStatus(new Status(Status.ERROR, PlatformUI.PLUGIN_ID, "Failed to check validity of name. See error log.", e));
			}
		}
	}

	protected String validateName(String name) {
		if (name.trim().isEmpty())
			return "Name cannot be empty";
		if (name.startsWith("."))
			return "Name cannot begin with a dot";
		return null;
	}

	public String getName() {
		return name;
	}

}