/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.lru;

import gnu.trove.map.hash.TIntIntHashMap;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.acorn.ClusterManager;
import org.simantics.acorn.cluster.ClusterImpl;
import org.simantics.acorn.exception.AcornAccessVerificationException;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.internal.BijectionMap;
import org.simantics.acorn.lru.ClusterInfo;
import org.simantics.acorn.lru.LRU;
import org.simantics.db.exception.ClusterDoesNotExistException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.service.ClusterUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterLRU
extends LRU<ClusterUID, ClusterInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterLRU.class);
    private final BijectionMap<ClusterUID, Integer> clusterMapping = new BijectionMap();

    public ClusterLRU(ClusterManager manager, String identifier, Path writeDir) {
        super(manager, identifier, writeDir);
        this.clusterMapping.map(ClusterUID.make((long)0L, (long)2L), this.clusterMapping.size() + 1);
    }

    public ClusterInfo getOrCreate(ClusterUID uid, boolean makeIfNull) throws IllegalAcornStateException, AcornAccessVerificationException {
        try {
            this.acquireMutex();
            ClusterInfo info = (ClusterInfo)this.get(uid);
            if (info == null) {
                if (!makeIfNull) {
                    throw new IllegalAcornStateException("Asked for an existing cluster " + uid + " that was not found.");
                }
                Integer clusterKey = this.clusterMapping.getRight(uid);
                if (clusterKey == null) {
                    clusterKey = this.clusterMapping.size() + 1;
                    this.clusterMapping.map(uid, clusterKey);
                }
                info = new ClusterInfo(this.manager, this, ClusterImpl.make(this.manager.support, uid, clusterKey, this.manager.support));
            }
            ClusterInfo clusterInfo = info;
            return clusterInfo;
        }
        catch (AcornAccessVerificationException | IllegalAcornStateException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IllegalAcornStateException(t);
        }
        finally {
            this.releaseMutex();
        }
    }

    public void ensureUpdates(ClusterUID uid) throws ClusterDoesNotExistException, AcornAccessVerificationException, IllegalAcornStateException {
        ClusterInfo info = (ClusterInfo)this.getWithoutMutex(uid);
        if (info == null) {
            throw new ClusterDoesNotExistException("Asked a cluster which does not exist: " + uid);
        }
        info.waitForUpdates();
    }

    public ClusterInfo get(ClusterUID uid, boolean makeIfNull, boolean ensureUpdates) throws AcornAccessVerificationException, IllegalAcornStateException {
        if (ensureUpdates) {
            try {
                this.ensureUpdates(uid);
            }
            catch (ClusterDoesNotExistException e) {
                if (makeIfNull) {
                    org.simantics.db.common.utils.Logger.defaultLogError((String)"For debug purposes, creating cluster which does not exist", (Throwable)e);
                }
                throw new IllegalAcornStateException(e);
            }
        }
        return this.getOrCreate(uid, makeIfNull);
    }

    public ClusterInfo get(ClusterUID uid, boolean makeIfNull) throws AcornAccessVerificationException, IllegalAcornStateException {
        return this.get(uid, makeIfNull, true);
    }

    public int getResourceKey(ClusterUID uid, int index) throws AcornAccessVerificationException {
        Integer i;
        if (VERIFY) {
            this.verifyAccess();
        }
        if ((i = this.clusterMapping.getRight(uid)) == null) {
            i = this.clusterMapping.size() + 1;
            this.clusterMapping.map(uid, i);
        }
        return (i << 12) + index;
    }

    public int getResourceKeyWithoutMutex(ClusterUID uid, int index) throws IllegalAcornStateException {
        this.acquireMutex();
        try {
            int n = this.getResourceKey(uid, index);
            return n;
        }
        catch (Throwable t) {
            throw new IllegalAcornStateException(t);
        }
        finally {
            this.releaseMutex();
        }
    }

    public int createClusterKeyByClusterUID(ClusterUID uid) throws AcornAccessVerificationException {
        Integer i;
        if (VERIFY) {
            this.verifyAccess();
        }
        if ((i = this.clusterMapping.getRight(uid)) == null) {
            i = this.clusterMapping.size() + 1;
            this.clusterMapping.map(uid, i);
        }
        return i;
    }

    public ClusterBase getClusterByClusterUIDOrMake(ClusterUID uid) throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        int key = this.createClusterKeyByClusterUID(uid);
        return this.getClusterByClusterKey(key);
    }

    public int getClusterKeyByClusterUIDOrMake(ClusterUID clusterUID) throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.createClusterKeyByClusterUID(clusterUID);
    }

    public int getClusterKeyByClusterUIDOrMakeWithoutMutex(ClusterUID clusterUID) throws IllegalAcornStateException, AcornAccessVerificationException {
        this.acquireMutex();
        try {
            int n = this.getClusterKeyByClusterUIDOrMake(clusterUID);
            return n;
        }
        catch (AcornAccessVerificationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IllegalAcornStateException(t);
        }
        finally {
            this.releaseMutex();
        }
    }

    public ClusterBase getClusterByClusterKey(int clusterKey) throws AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        ClusterUID uid = this.clusterMapping.getLeft(clusterKey);
        ClusterInfo info = this.get(uid, true);
        info.acquireMutex();
        try {
            ClusterImpl clusterImpl = info.getCluster();
            return clusterImpl;
        }
        catch (AcornAccessVerificationException | IllegalAcornStateException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IllegalAcornStateException(t);
        }
        finally {
            info.releaseMutex();
        }
    }

    public ClusterUID getClusterUIDByResourceKey(int resourceKey) throws AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        int clusterKey = resourceKey >> 12;
        return this.clusterMapping.getLeft(clusterKey);
    }

    public ClusterUID getClusterUIDByResourceKeyWithoutMutex(int resourceKey) throws IllegalAcornStateException, AcornAccessVerificationException {
        this.acquireMutex();
        try {
            ClusterUID clusterUID = this.getClusterUIDByResourceKey(resourceKey);
            return clusterUID;
        }
        finally {
            this.releaseMutex();
        }
    }

    public <T extends ClusterI> T getClusterByClusterUIDOrMakeProxy(ClusterUID uid) throws DatabaseException, AcornAccessVerificationException, IllegalAcornStateException {
        return (T)this.getClusterByClusterUIDOrMake(uid);
    }

    public <T extends ClusterI> T getClusterProxyByResourceKey(int resourceKey) throws DatabaseException, AcornAccessVerificationException, IllegalAcornStateException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return (T)this.getClusterByClusterKey(resourceKey >> 12);
    }

    public int getClusterKeyByUID(long id1, long id2) throws DatabaseException, AcornAccessVerificationException {
        if (VERIFY) {
            this.verifyAccess();
        }
        return this.getClusterKeyByClusterUIDOrMake(ClusterUID.make((long)id1, (long)id2));
    }

    public int getClusterKeyByUIDWithoutMutex(long id1, long id2) throws DatabaseException, IllegalAcornStateException {
        this.acquireMutex();
        try {
            int n = this.getClusterKeyByClusterUIDOrMake(ClusterUID.make((long)id1, (long)id2));
            return n;
        }
        catch (Throwable t) {
            throw new IllegalAcornStateException(t);
        }
        finally {
            this.releaseMutex();
        }
    }

    public static void main(String[] args) throws Exception {
        long start = System.nanoTime();
        final TIntIntHashMap map = new TIntIntHashMap(0, 0.9f);
        final AtomicInteger counter = new AtomicInteger(0);
        final AtomicBoolean written = new AtomicBoolean(false);
        Thread write = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int i = 0;
                    while (i < 100000000) {
                        TIntIntHashMap tIntIntHashMap = map;
                        synchronized (tIntIntHashMap) {
                            map.put(i, i);
                        }
                        counter.incrementAndGet();
                        ++i;
                    }
                    written.set(true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        write.start();
        Thread read = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block5: while (true) {
                    try {
                        while (!written.get()) {
                            int value;
                            double r = Math.random();
                            double max = counter.get();
                            int key = (int)(max * r);
                            if (key == (value = map.get(key))) continue;
                            TIntIntHashMap tIntIntHashMap = map;
                            synchronized (tIntIntHashMap) {
                                value = map.get(key);
                                if (key != value) {
                                    LOGGER.warn("Read failed for real " + key + " vs. " + value);
                                }
                                continue block5;
                            }
                        }
                        break;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
        };
        read.start();
        write.join();
        read.join();
        if (LOGGER.isDebugEnabled()) {
            long duration = System.nanoTime() - start;
            LOGGER.debug("took " + 1.0E-9 * (double)duration + "s.");
        }
    }
}

