/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.simantics.acorn.FileIO;
import org.simantics.acorn.HeadState;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.util.binary.BinaryMemory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainState
implements Serializable {
    private static final long serialVersionUID = 6237383147637270225L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MainState.class);
    public static final String MAIN_STATE = "main.state";
    public int headDir;
    private static final DateTimeFormatter RECOVERY_DIR_FORMAT = DateTimeFormatter.ofPattern("yyyy-M-d_HH-mm-ss");

    public MainState() {
        this.headDir = 0;
    }

    private MainState(int headDir) {
        this.headDir = headDir;
    }

    public boolean isInitial() {
        return this.headDir == 0;
    }

    public static MainState load(Path directory, Runnable rollbackCallback) throws IOException {
        Files.createDirectories(directory, new FileAttribute[0]);
        Path mainState = directory.resolve(MAIN_STATE);
        try {
            int latestRevision;
            block13: {
                MainState state = (MainState)org.simantics.databoard.Files.readFile((File)mainState.toFile(), (Binding)Bindings.getBindingUnchecked(MainState.class));
                latestRevision = state.headDir - 1;
                try {
                    if (!HeadState.validateHeadStateIntegrity(directory.resolve(String.valueOf(latestRevision) + "/" + "head.state"))) break block13;
                    MainState.archiveRevisionDirectories(directory, latestRevision, rollbackCallback);
                    MainState mainState2 = state;
                    return mainState2;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LOGGER.warn("Failed to start database from revision " + latestRevision + " stored in " + mainState + ". Revision does not contain " + "head.state" + ".");
                    MainState mainState3 = MainState.rollback(directory, rollbackCallback);
                    return mainState3;
                }
            }
            LOGGER.warn("Failed to start database from revision " + latestRevision + " stored in " + mainState + ". " + "head.state" + " is invalid.");
            MainState mainState4 = MainState.rollback(directory, rollbackCallback);
            return mainState4;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (MainState.listRevisionDirs(directory, true, MainState::isInteger).isEmpty()) {
                MainState mainState5 = new MainState(0);
                return mainState5;
            }
            LOGGER.warn("Unclean exit detected, " + mainState + " not found. Initiating automatic rollback.");
            MainState mainState6 = MainState.rollback(directory, rollbackCallback);
            return mainState6;
        }
        catch (Exception e) {
            LOGGER.warn("Unclean exit detected. Initiating automatic rollback.", (Throwable)e);
            MainState mainState7 = MainState.rollback(directory, rollbackCallback);
            return mainState7;
        }
        finally {
            Files.deleteIfExists(mainState);
        }
    }

    private static MainState rollback(Path directory, Runnable rollbackCallback) throws IOException {
        LOGGER.warn("Database rollback initiated for " + directory);
        rollbackCallback.run();
        Path latest = MainState.findNewHeadStateDir(directory);
        int latestRevision = latest != null ? MainState.safeParseInt(-1, latest) : -1;
        MainState state = new MainState(latestRevision + 1);
        MainState.archiveRevisionDirectories(directory, latestRevision, rollbackCallback);
        LOGGER.warn("Database rollback completed. Restarting database from revision " + latest);
        return state;
    }

    private byte[] toByteArray() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BinaryMemory rf = new BinaryMemory(4096);){
            Bindings.getSerializerUnchecked((Binding)Bindings.VARIANT).serialize((DataOutput)rf, (Object)MutableVariant.ofInstance((Object)this));
            return rf.toByteBuffer().array();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void save(Path directory) throws IOException {
        Path f = directory.resolve(MAIN_STATE);
        Files.write(f, this.toByteArray(), new OpenOption[0]);
        FileIO.syncPath(f);
    }

    private static int safeParseInt(int defaultValue, Path p) {
        try {
            return Integer.parseInt(p.getFileName().toString());
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private static boolean isInteger(Path p) {
        return MainState.safeParseInt(Integer.MIN_VALUE, p) != Integer.MIN_VALUE;
    }

    private static Predicate<Path> isGreaterThan(int i) {
        return p -> {
            int pi = MainState.safeParseInt(Integer.MIN_VALUE, p);
            return pi != Integer.MIN_VALUE && pi > i;
        };
    }

    private static Path findNewHeadStateDir(Path directory) throws IOException {
        for (Path last : MainState.listRevisionDirs(directory, true, MainState::isInteger)) {
            if (!HeadState.validateHeadStateIntegrity(last.resolve("head.state"))) continue;
            return last;
        }
        return null;
    }

    private static void archiveRevisionDirectories(Path directory, int greaterThanRevision, Runnable rollbackCallback) throws IOException {
        List<Path> reverseSortedPaths = MainState.listRevisionDirs(directory, true, MainState.isGreaterThan(greaterThanRevision));
        if (reverseSortedPaths.isEmpty()) {
            return;
        }
        if (!MainState.anyContainsHeadState(reverseSortedPaths)) {
            for (Path p : reverseSortedPaths) {
                MainState.deleteAll(p);
                LOGGER.info("Removed useless working folder " + p);
            }
            return;
        }
        rollbackCallback.run();
        Path recoveryFolder = MainState.getRecoveryFolder(directory);
        Files.createDirectories(recoveryFolder, new FileAttribute[0]);
        LOGGER.info("Created new database recovery folder " + recoveryFolder);
        for (Path p : reverseSortedPaths) {
            Files.move(p, recoveryFolder.resolve(p.getFileName().toString()), new CopyOption[0]);
            LOGGER.info("Archived revision " + p + " in recovery folder " + recoveryFolder);
        }
    }

    private static boolean anyContainsHeadState(List<Path> paths) {
        for (Path p : paths) {
            if (!Files.exists(p.resolve("head.state"), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    private static List<Path> listRevisionDirs(Path directory, boolean descending, Predicate<Path> ... filters) throws IOException {
        int coef = descending ? -1 : 1;
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<Path> s = Files.walk(directory, 1, new FileVisitOption[0]);){
            Stream<Path> fs = s.filter(p -> !p.equals(directory));
            Predicate<Path>[] predicateArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                Predicate<Path> p3 = predicateArray[n2];
                fs = fs.filter(p3);
                ++n2;
            }
            return fs.filter(path -> Files.isDirectory(path, new LinkOption[0])).sorted((p1, p2) -> coef * Integer.compare(Integer.parseInt(p1.getFileName().toString()), Integer.parseInt(p2.getFileName().toString()))).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void deleteAll(Path dir) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static Path getRecoveryFolder(Path directory) {
        return MainState.findNonexistentDir(directory.resolve("recovery"), RECOVERY_DIR_FORMAT.format(ZonedDateTime.now()));
    }

    private static Path findNonexistentDir(Path inDirectory, String prefix) {
        int i = 0;
        Path dir;
        while (!Files.notExists(dir = inDirectory.resolve(i == 0 ? prefix : String.valueOf(prefix) + "-" + i), new LinkOption[0])) {
            ++i;
        }
        return dir;
    }
}

