/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.acorn.FileIO;
import org.simantics.acorn.HeadState1;
import org.simantics.acorn.exception.InvalidHeadStateException;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.util.binary.BinaryMemory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadState {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(HeadState.class);
    public static final String HEAD_STATE = "head.state";
    public static final String SHA_1 = "SHA-1";
    public int headChangeSetId = 0;
    public long transactionId = 1L;
    public long reservedIds = 3L;
    public ArrayList<String> clusters = new ArrayList();
    public ArrayList<String> files = new ArrayList();
    public ArrayList<String> stream = new ArrayList();
    public ArrayList<String> cs = new ArrayList();
    public long tailChangeSetId = 1L;

    public static HeadState load(Path directory) throws InvalidHeadStateException {
        Path f = directory.resolve(HEAD_STATE);
        try {
            byte[] bytes = Files.readAllBytes(f);
            MessageDigest sha1 = MessageDigest.getInstance(SHA_1);
            int digestLength = sha1.getDigestLength();
            sha1.update(bytes, digestLength, bytes.length - digestLength);
            byte[] newChecksum = sha1.digest();
            if (!Arrays.equals(newChecksum, Arrays.copyOfRange(bytes, 0, digestLength))) {
                throw new InvalidHeadStateException("Checksum " + Arrays.toString(newChecksum) + " does not match excpected " + Arrays.toString(Arrays.copyOfRange(bytes, 0, digestLength)) + " for " + f.toAbsolutePath());
            }
            Throwable throwable = null;
            Object var7_13 = null;
            try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes, digestLength, bytes.length - digestLength);){
                HeadState object = (HeadState)org.simantics.databoard.Files.readFile((InputStream)bais, (Binding)Bindings.getBindingUnchecked(HeadState.class));
                return object;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException i) {
            Throwable cause = i.getCause();
            if (cause instanceof AdapterConstructionException) {
                HeadState1 old = HeadState1.load(directory);
                return old.migrate();
            }
            throw new InvalidHeadStateException(i);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("SHA-1 Algorithm not found", e);
        }
        catch (Throwable t) {
            throw new InvalidHeadStateException(t);
        }
    }

    public void save(Path directory) throws IOException {
        Path f = directory.resolve(HEAD_STATE);
        try {
            try (BinaryMemory rf = new BinaryMemory(4096);){
                MutableVariant v = new MutableVariant(Bindings.getBindingUnchecked(HeadState.class), (Object)this);
                Serializer s = Bindings.getSerializerUnchecked((Binding)Bindings.VARIANT);
                s.serialize((DataOutput)rf, (Object)v);
            }
            byte[] bytes = rf.toByteBuffer().array();
            MessageDigest sha1 = MessageDigest.getInstance(SHA_1);
            sha1.update(bytes);
            byte[] checksum = sha1.digest();
            Throwable throwable = null;
            Object var8_11 = null;
            try (OutputStream out = Files.newOutputStream(f, new OpenOption[0]);){
                out.write(checksum);
                out.write(bytes);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            FileIO.syncPath(f);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("SHA-1 digest not found, should not happen", e);
        }
    }

    public static boolean validateHeadStateIntegrity(Path headState) {
        if (!Files.exists(headState, new LinkOption[0])) {
            return false;
        }
        try {
            byte[] bytes = Files.readAllBytes(headState);
            MessageDigest sha1 = MessageDigest.getInstance(SHA_1);
            int digestLength = sha1.getDigestLength();
            sha1.update(bytes, digestLength, bytes.length - digestLength);
            byte[] newChecksum = sha1.digest();
            if (!Arrays.equals(newChecksum, Arrays.copyOfRange(bytes, 0, digestLength))) {
                LOGGER.error("Checksum " + Arrays.toString(newChecksum) + " does not match excpected " + Arrays.toString(Arrays.copyOfRange(bytes, 0, digestLength)) + " for " + headState.toAbsolutePath());
                return false;
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("An I/O error occured while validating integrity of head.state", (Throwable)e);
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("SHA-1 digest not found, should not happen", (Throwable)e);
            throw new Error("SHA-1 digest not found, should not happen", e);
        }
    }
}

