/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.r.scl;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;
import org.simantics.db.layer0.variable.NodeSupport;
import org.simantics.r.scl.RSession;
import org.simantics.r.scl.RSessionConfiguration;
import org.simantics.scl.runtime.function.Function;

public class RSessionManager {
    static ConcurrentHashMap<String, RSession> CONNECTIONS = new ConcurrentHashMap();
    static ConcurrentHashMap<String, NodeSupport<String>> SUPPORTS = new ConcurrentHashMap();

    public static RSession getSession(String id) {
        return CONNECTIONS.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSession createSession(RSessionConfiguration configuration) throws RserveException {
        ConcurrentHashMap<String, RSession> concurrentHashMap = CONNECTIONS;
        synchronized (concurrentHashMap) {
            String id = UUID.randomUUID().toString();
            return RSessionManager.createSession(configuration, id);
        }
    }

    public static Object withConfiguration(RSessionConfiguration configuration, Function f) throws RserveException {
        try (RSession session = RSessionManager.createSession(configuration);){
            Object object = session.syncExec(f);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSession getOrCreateSession(RSessionConfiguration configuration, String id) throws RserveException {
        ConcurrentHashMap<String, RSession> concurrentHashMap = CONNECTIONS;
        synchronized (concurrentHashMap) {
            RSession session = RSessionManager.getSession(id);
            if (session == null) {
                return RSessionManager.createSession(configuration, id);
            }
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RSession createSession(RSessionConfiguration configuration, String id) throws RserveException {
        ConcurrentHashMap<String, RSession> concurrentHashMap = CONNECTIONS;
        synchronized (concurrentHashMap) {
            RConnection connection = new RConnection(configuration.host, configuration.port);
            if (configuration.username != null && !configuration.username.isEmpty()) {
                connection.login(configuration.username, configuration.password);
            }
            RSession managedConnection = new RSession(connection, id);
            CONNECTIONS.put(id, managedConnection);
            return managedConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeSupport<String> getOrCreateNodeSupport(String id) {
        ConcurrentHashMap<String, NodeSupport<String>> concurrentHashMap = SUPPORTS;
        synchronized (concurrentHashMap) {
            NodeSupport result = SUPPORTS.get(id);
            if (result == null) {
                RSession session = RSessionManager.getSession(id);
                result = new NodeSupport(session.getNodeManager());
                SUPPORTS.put(id, (NodeSupport<String>)result);
            }
            return result;
        }
    }
}

