/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.Rserve;

import java.io.IOException;
import java.io.InputStream;
import org.rosuda.REngine.Rserve.protocol.RPacket;
import org.rosuda.REngine.Rserve.protocol.RTalk;

public class RFileInputStream
extends InputStream {
    RTalk rt;
    boolean closed;
    boolean eof;

    RFileInputStream(RTalk rti, String fn) throws IOException {
        this.rt = rti;
        RPacket rp = this.rt.request(16, fn);
        if (rp == null || !rp.isOk()) {
            throw new IOException(rp == null ? "Connection to Rserve failed" : "Request return code: " + rp.getStat());
        }
        this.closed = false;
        this.eof = false;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) < 1) {
            return -1;
        }
        return b[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("File is not open");
        }
        if (this.eof) {
            return -1;
        }
        RPacket rp = this.rt.request(19, len);
        if (rp == null || !rp.isOk()) {
            throw new IOException(rp == null ? "Connection to Rserve failed" : "Request return code: " + rp.getStat());
        }
        byte[] rd = rp.getCont();
        if (rd == null) {
            this.eof = true;
            return -1;
        }
        int i = 0;
        while (i < rd.length) {
            b[off + i] = rd[i];
            ++i;
        }
        return rd.length;
    }

    @Override
    public void close() throws IOException {
        RPacket rp = this.rt.request(18, (byte[])null);
        if (rp == null || !rp.isOk()) {
            throw new IOException(rp == null ? "Connection to Rserve failed" : "Request return code: " + rp.getStat());
        }
        this.closed = true;
    }
}

