#ifndef __MAIN_H__
#define __MAIN_H__

// Avoid use of the PyRun_StringFlags API to maintain compatibility with python3.dll
#define Py_LIMITED_API 0x03050000

#define PyTuple_GET_ITEM PyTuple_Get_Item
#define PyTuple_GET_SIZE PyTuple_Get_Size
#define PyTuple_SET_ITEM PyTuple_Set_Item

#define NPY_NO_DEPRECATED_API NPY_1_7_API_VERSION
#ifdef _DEBUG
	#undef _DEBUG
	#include <Python.h>  //header for system python import; add include paths
	#include <numpy/arrayobject.h>
	#define _DEBUG 1
#else
	#include <Python.h>  //header for system python import; add include paths
	#include <numpy/arrayobject.h>
#endif

#include <jni.h> //java connection header

/*  To use this exported function of dll, include this header
 *  in your project.
 */

#ifdef BUILD_DLL
    #define DLL_EXPORT __declspec(dllexport)
#else
    #define DLL_EXPORT __declspec(dllimport)
#endif


#define JAVA_MAXINT (0x7fffffff)

#define PYTHON_EXCEPTION "org/simantics/pythonlink/PythonException"
#define ILLEGAL_ARGUMENT_EXCEPTION "java/lang/IllegalArgumentException"
#define OBJECT_CLASS "java/lang/Object"
#define STRING_CLASS "java/lang/String"
#define MAP_CLASS "java/util/Map"
#define SET_CLASS "java/util/Set"

#define WRITER_CLASS "java/io/Writer"

#define PACKAGE_PREFIX "org/simantics/pythonlink/"

#define NDARRAY_CLASS (PACKAGE_PREFIX "NDArray")

#define VARIANT_CLASS "org/simantics/databoard/binding/mutable/Variant"
#define BINDINGS_CLASS "org/simantics/databoard/Bindings"
#define BINDING_CLASS "org/simantics/databoard/binding/Binding"
#define DATATYPE_CLASS "org/simantics/databoard/type/Datatype"

#define BOOLEANTYPE_CLASS "org/simantics/databoard/type/BooleanType"
#define BYTETYPE_CLASS "org/simantics/databoard/type/ByteType"
#define INTEGERTYPE_CLASS "org/simantics/databoard/type/IntegerType"
#define LONGTYPE_CLASS "org/simantics/databoard/type/LongType"
#define FLOATTYPE_CLASS "org/simantics/databoard/type/FloatType"
#define DOUBLETYPE_CLASS "org/simantics/databoard/type/DoubleType"
#define STRINGTYPE_CLASS "org/simantics/databoard/type/StringType"
#define RECORDTYPE_CLASS "org/simantics/databoard/type/RecordType"
#define ARRAYTYPE_CLASS "org/simantics/databoard/type/ArrayType"
#define MAPTYPE_CLASS "org/simantics/databoard/type/MapType"
#define OPTIONALTYPE_CLASS "org/simantics/databoard/type/OptionalType"
#define UNIONTYPE_CLASS "org/simantics/databoard/type/UnionType"
#define VARIANTTYPE_CLASS "org/simantics/databoard/type/VariantType"

#define BOOLEANBINDING_CLASS "org/simantics/databoard/binding/BooleanBinding"
#define BYTEBINDING_CLASS "org/simantics/databoard/binding/ByteBinding"
#define INTEGERBINDING_CLASS "org/simantics/databoard/binding/IntegerBinding"
#define LONGBINDING_CLASS "org/simantics/databoard/binding/LongBinding"
#define FLOATBINDING_CLASS "org/simantics/databoard/binding/FloatBinding"
#define DOUBLEBINDING_CLASS "org/simantics/databoard/binding/DoubleBinding"
#define STRINGBINDING_CLASS "org/simantics/databoard/binding/StringBinding"
#define RECORDBINDING_CLASS "org/simantics/databoard/binding/RecordBinding"
#define ARRAYBINDING_CLASS "org/simantics/databoard/binding/ArrayBinding"
#define MAPBINDING_CLASS "org/simantics/databoard/binding/MapBinding"
#define OPTIONALBINDING_CLASS "org/simantics/databoard/binding/OptionalBinding"
#define UNIONBINDING_CLASS "org/simantics/databoard/binding/UnionBinding"
#define VARIANTBINDING_CLASS "org/simantics/databoard/binding/VariantBinding"

#define COMPONENT_CLASS "org/simantics/databoard/type/Component"
#define TAGGEDOBJECT_CLASS "org/simantics/databoard/binding/mutable/TaggedObject"

PyObject *getPythonBooleanList(JNIEnv *env, jbooleanArray value);
PyObject *getPythonByteArray(JNIEnv *env, jbyteArray value);
PyObject *getPythonIntegerList(JNIEnv *env, jintArray value);
PyObject *getPythonLongList(JNIEnv *env, jlongArray value);
PyObject *getPythonFloatList(JNIEnv *env, jfloatArray value);
PyObject *getPythonDoubleList(JNIEnv *env, jdoubleArray value);

PyObject *getPythonObject(JNIEnv *env, jobject object, jobject binding);

PyObject *getPythonBooleanObject(JNIEnv *env, jobject object, jobject binding);
PyObject *getPythonByteObject(JNIEnv *env, jobject object, jobject binding);
PyObject *getPythonIntegerObject(JNIEnv *env, jobject object, jobject binding);
PyObject *getPythonLongObject(JNIEnv *env, jobject object, jobject binding);
PyObject *getPythonFloatObject(JNIEnv *env, jobject object, jobject binding);
PyObject *getPythonDoubleObject(JNIEnv *env, jobject object, jobject binding);
PyObject *getPythonRecordObject(JNIEnv *env, jobjectArray object, jobject binding);
PyObject *getPythonArrayObject(JNIEnv *env, jobject object, jobject binding);
PyObject *getPythonMapObject(JNIEnv *env, jobject object, jobject binding);
PyObject *getPythonOptionalObject(JNIEnv *env, jobject object, jobject binding);
PyObject *getPythonUnionObject(JNIEnv *env, jobject object, jobject binding);
PyObject *getPythonVariantObject(JNIEnv *env, jobject object, jobject binding);

void setPythonVariable(PyObject *module, PyObject *name, PyObject *value);

jobject pythonBoolAsBooleanObject(JNIEnv *env, PyObject *value);
jobject pythonLongAsLongObject(JNIEnv *env, PyObject *value);
jobject pythonFloatAsDoubleObject(JNIEnv *env, PyObject *value);
jobject pythonByteArrayAsByteArray(JNIEnv *env, PyObject *value);
jstring pythonStringAsJavaString(JNIEnv *env, PyObject *string);
jobjectArray pythonSequenceAsObjectArray(JNIEnv *env, PyObject *seq);
jobjectArray pythonSequenceAsStringArray(JNIEnv *env, PyObject *list);
jintArray pythonSequenceAsIntegerArray(JNIEnv *env, PyObject *list);
jlongArray pythonSequenceAsLongArray(JNIEnv *env, PyObject *list);
jdoubleArray pythonSequenceAsDoubleArray(JNIEnv *env, PyObject *list);
jobject pythonDictionaryAsMap(JNIEnv *env, PyObject *dict);
jobject pythonArrayAsNDArray(JNIEnv *env, PyArrayObject *array);
jobject pythonObjectAsObject(JNIEnv *env, PyObject *value);

#endif // __MAIN_H__
