/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.property;

import org.simantics.g3d.property.PropertyManipulator;
import org.simantics.g3d.property.ValueProvider;

public class BooleanPropertyManipulator
implements PropertyManipulator {
    ValueProvider provider;
    Object input;
    boolean editMode;
    String editValue = null;

    public BooleanPropertyManipulator(ValueProvider provider, Object input) {
        this.provider = provider;
        this.input = input;
    }

    @Override
    public int getValueCount() {
        return 1;
    }

    @Override
    public String getDescription(int i) {
        if (i == 0) {
            return "Value";
        }
        return null;
    }

    @Override
    public String getValue(int i) {
        Object value;
        block4: {
            if (this.editMode) {
                return this.editValue;
            }
            try {
                value = this.provider.getValue(this.input);
                if (value != null) break block4;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return value.toString();
    }

    @Override
    public String setValue(String value, int i) {
        try {
            this.editValue = value;
            this.provider.setValue(this.input, Boolean.parseBoolean(value));
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    @Override
    public boolean getEditMode() {
        return this.editMode;
    }

    @Override
    public void setEditMode(boolean b) {
        this.editMode = b;
        if (this.editMode) {
            try {
                this.editValue = this.provider.getValue(this.input).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

