/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.property;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.ComboBoxCellEditor2;
import org.simantics.db.management.ISessionContext;
import org.simantics.g3d.property.ComboPropertyManipulator;
import org.simantics.g3d.property.MethodComboValueProvider;
import org.simantics.g3d.property.MethodValueProvider;
import org.simantics.g3d.property.MethodWithMapValueProvider;
import org.simantics.g3d.property.PropertyManipulator;
import org.simantics.g3d.property.PropertyManipulatorFactory;
import org.simantics.g3d.property.PropertyTabContributor;
import org.simantics.g3d.property.PropertyTabContributorFactory;
import org.simantics.g3d.property.ValueProvider;
import org.simantics.g3d.property.annotations.CompoundGetPropertyValue;
import org.simantics.g3d.property.annotations.CompoundSetPropertyValue;
import org.simantics.g3d.property.annotations.GetComboProperty;
import org.simantics.g3d.property.annotations.GetComboPropertyValue;
import org.simantics.g3d.property.annotations.GetPropertyValue;
import org.simantics.g3d.property.annotations.PropertyTabBlacklist;
import org.simantics.g3d.property.annotations.SetComboPropertyValue;
import org.simantics.g3d.property.annotations.SetPropertyValue;
import org.simantics.g3d.scenegraph.NodeMap;
import org.simantics.g3d.scenegraph.NodeMapProvider;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.NodeListener;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.scenegraph.structural.IStructuralNode;
import org.simantics.g3d.tools.AdaptationUtils;
import org.simantics.selectionview.IPropertyTab;
import org.simantics.selectionview.IPropertyTab2;
import org.simantics.utils.datastructures.MapList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedPropertyTabContributorFactory
implements PropertyTabContributorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotatedPropertyTabContributorFactory.class);

    @Override
    public List<PropertyTabContributor> getContributors(Object input) {
        LinkedHashMap<String, IPropertyItem> items = new LinkedHashMap<String, IPropertyItem>();
        ArrayList<String> blacklist = new ArrayList<String>();
        try {
            AnnotatedPropertyTabContributorFactory.collectItems(input.getClass(), items);
            AnnotatedPropertyTabContributorFactory.collectBlacklist(input.getClass(), blacklist);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (items.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        MapList tabMap = new MapList();
        ArrayList<String> tabs = new ArrayList<String>();
        for (String id : items.keySet()) {
            IPropertyItem item = (IPropertyItem)items.get(id);
            tabMap.add((Object)item.getTabId(), (Object)item);
            if (tabs.contains(item.getTabId())) continue;
            tabs.add(item.getTabId());
        }
        for (String s : blacklist) {
            tabs.remove(s);
        }
        ArrayList<PropertyTabContributor> contributors = new ArrayList<PropertyTabContributor>(tabs.size());
        for (String tabId : tabs) {
            contributors.add(new AnnotatedPropertyTabContributor(tabId, tabMap.getValues((Object)tabId)));
        }
        return contributors;
    }

    private static void collectItems(Class<?> clazz, Map<String, IPropertyItem> items) throws InstantiationException, IllegalAccessException {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            AnnotatedPropertyTabContributorFactory.collectItems(superclass, items);
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            m.setAccessible(true);
            Annotation[] annotationArray = m.getAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation set;
                IPropertyItem item;
                Annotation get;
                Annotation annotation = annotationArray[n4];
                if (annotation.annotationType().equals(GetPropertyValue.class)) {
                    get = (GetPropertyValue)annotation;
                    item = (PropertyItem)items.get(get.value());
                    if (item == null) {
                        item = new PropertyItem(get.value());
                        items.put(((PropertyItem)item).id, item);
                    }
                    ((PropertyItem)item).getter = m;
                    ((PropertyItem)item).manipulatorClass = get.manipulator().newInstance().get(m, null);
                    ((PropertyItem)item).tabId = get.tabId();
                    ((PropertyItem)item).name = get.name();
                } else if (annotation.annotationType().equals(SetPropertyValue.class)) {
                    set = (SetPropertyValue)annotation;
                    item = (PropertyItem)items.get(set.value());
                    if (item == null) {
                        item = new PropertyItem(set.value());
                        items.put(((PropertyItem)item).id, item);
                    }
                    ((PropertyItem)item).setter = m;
                } else if (annotation.annotationType().equals(CompoundGetPropertyValue.class)) {
                    get = (CompoundGetPropertyValue)annotation;
                    item = (CompoundPropertyItem)items.get(get.value());
                    if (item == null) {
                        item = new CompoundPropertyItem(get.value());
                        items.put(((CompoundPropertyItem)item).id, item);
                    }
                    ((CompoundPropertyItem)item).getter = m;
                    ((CompoundPropertyItem)item).manipulatorFactory = get.manipulator().newInstance();
                    ((CompoundPropertyItem)item).tabId = get.tabId();
                    ((CompoundPropertyItem)item).name = get.name();
                } else if (annotation.annotationType().equals(CompoundSetPropertyValue.class)) {
                    set = (CompoundSetPropertyValue)annotation;
                    item = (CompoundPropertyItem)items.get(set.value());
                    if (item == null) {
                        item = new CompoundPropertyItem(set.value());
                        items.put(((CompoundPropertyItem)item).id, item);
                    }
                    ((CompoundPropertyItem)item).setter = m;
                } else if (annotation.annotationType().equals(GetComboPropertyValue.class)) {
                    get = (GetComboPropertyValue)annotation;
                    item = (ComboPropertyItem)items.get(get.value());
                    if (item == null) {
                        item = new ComboPropertyItem(get.value());
                        items.put(((ComboPropertyItem)item).id, item);
                    }
                    ((ComboPropertyItem)item).getter = m;
                    ((ComboPropertyItem)item).manipulatorClass = ComboPropertyManipulator.class;
                    ((ComboPropertyItem)item).tabId = get.tabId();
                    ((ComboPropertyItem)item).name = get.name();
                } else if (annotation.annotationType().equals(SetComboPropertyValue.class)) {
                    set = (SetComboPropertyValue)annotation;
                    item = (ComboPropertyItem)items.get(set.value());
                    if (item == null) {
                        item = new ComboPropertyItem(set.value());
                        items.put(((ComboPropertyItem)item).id, item);
                    }
                    ((ComboPropertyItem)item).setter = m;
                } else if (annotation.annotationType().equals(GetComboProperty.class)) {
                    get = (GetComboProperty)annotation;
                    item = (ComboPropertyItem)items.get(get.value());
                    if (item == null) {
                        item = new ComboPropertyItem(get.value());
                        items.put(((ComboPropertyItem)item).id, item);
                    }
                    ((ComboPropertyItem)item).values = m;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void collectBlacklist(Class<?> clazz, List<String> blacklist) throws InstantiationException, IllegalAccessException {
        PropertyTabBlacklist ann;
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            AnnotatedPropertyTabContributorFactory.collectBlacklist(superclass, blacklist);
        }
        if ((ann = clazz.getAnnotation(PropertyTabBlacklist.class)) == null) {
            return;
        }
        String s = ann.value();
        if (s == null) {
            return;
        }
        if (s.length() == 0) {
            return;
        }
        String[] stringArray = s.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            blacklist.add(item);
            ++n2;
        }
    }

    private static Map<PropertyItem, PropertyManipulator> createManipulators(CompoundPropertyItem item, Object obj) {
        try {
            Map map = (Map)item.getter.invoke(obj, new Object[0]);
            HashMap<PropertyItem, PropertyManipulator> result = new HashMap<PropertyItem, PropertyManipulator>();
            for (String key : map.keySet()) {
                MethodWithMapValueProvider provider = new MethodWithMapValueProvider(item.getter, item.setter, key);
                Class<? extends PropertyManipulator> clazz = item.manipulatorFactory.get(null, map.get(key));
                PropertyManipulator manipulator = clazz.getConstructor(ValueProvider.class, Object.class).newInstance(provider, obj);
                PropertyItem i = new PropertyItem(String.valueOf(item.id) + "." + key);
                i.getter = item.getter;
                i.setter = item.setter;
                i.name = key;
                i.tabId = item.tabId;
                result.put(i, manipulator);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyMap();
        }
    }

    private static PropertyManipulator createManipulator(PropertyItem item, Object obj) {
        try {
            MethodValueProvider provider = new MethodValueProvider(item.getter, item.setter);
            PropertyManipulator manipulator = (PropertyManipulator)item.manipulatorClass.getConstructor(ValueProvider.class, Object.class).newInstance(provider, obj);
            return manipulator;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static PropertyManipulator createManipulator(ComboPropertyItem item, Object obj) {
        try {
            MethodComboValueProvider provider = new MethodComboValueProvider(item.getter, item.setter, item.values);
            PropertyManipulator manipulator = (PropertyManipulator)item.manipulatorClass.getConstructor(ValueProvider.class, Object.class).newInstance(provider, obj);
            return manipulator;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ViewerCell getNeighbor(ViewerCell currentCell, int directionMask, boolean sameLevel) {
        ViewerRow row = (directionMask & ViewerCell.ABOVE) == ViewerCell.ABOVE ? currentCell.getViewerRow().getNeighbor(1, sameLevel) : ((directionMask & ViewerCell.BELOW) == ViewerCell.BELOW ? currentCell.getViewerRow().getNeighbor(2, sameLevel) : currentCell.getViewerRow());
        if (row != null) {
            int columnIndex = AnnotatedPropertyTabContributorFactory.getVisualIndex(row, currentCell.getColumnIndex());
            int modifier = 0;
            if ((directionMask & ViewerCell.LEFT) == ViewerCell.LEFT) {
                modifier = -1;
            } else if ((directionMask & ViewerCell.RIGHT) == ViewerCell.RIGHT) {
                modifier = 1;
            }
            if ((columnIndex += modifier) >= 0 && columnIndex < row.getColumnCount()) {
                ViewerCell cell = AnnotatedPropertyTabContributorFactory.getCellAtVisualIndex(row, columnIndex);
                if (cell != null) {
                    while (cell != null && columnIndex < row.getColumnCount() - 1 && columnIndex > 0) {
                        if (AnnotatedPropertyTabContributorFactory.isVisible(cell) || (cell = AnnotatedPropertyTabContributorFactory.getCellAtVisualIndex(row, columnIndex += modifier)) == null) break;
                    }
                }
                return cell;
            }
        }
        return null;
    }

    private static int getVisualIndex(ViewerRow row, int creationIndex) {
        TableItem item = (TableItem)row.getItem();
        int[] order = item.getParent().getColumnOrder();
        int i = 0;
        while (i < order.length) {
            if (order[i] == creationIndex) {
                return i;
            }
            ++i;
        }
        return creationIndex;
    }

    private static int getCreationIndex(ViewerRow row, int visualIndex) {
        TableItem item = (TableItem)row.getItem();
        if (item != null && !item.isDisposed()) {
            return item.getParent().getColumnOrder()[visualIndex];
        }
        return visualIndex;
    }

    private static ViewerCell getCellAtVisualIndex(ViewerRow row, int visualIndex) {
        return AnnotatedPropertyTabContributorFactory.getCell(row, AnnotatedPropertyTabContributorFactory.getCreationIndex(row, visualIndex));
    }

    private static boolean isVisible(ViewerCell cell) {
        return AnnotatedPropertyTabContributorFactory.getWidth(cell) > 0;
    }

    private static int getWidth(ViewerCell cell) {
        TableItem item = (TableItem)cell.getViewerRow().getItem();
        return item.getParent().getColumn(cell.getColumnIndex()).getWidth();
    }

    private static ViewerCell getCell(ViewerRow row, int index) {
        return row.getCell(index);
    }

    private static class AnnotatedPropertyTab
    implements IPropertyTab2,
    NodeListener {
        List<IPropertyItem> contibutedItems;
        List<IPropertyItem> resolvedItems = new ArrayList<IPropertyItem>();
        private Map<IPropertyItem, PropertyManipulator> manipulators = new HashMap<IPropertyItem, PropertyManipulator>();
        private TableViewer viewer;
        private INode node;
        private NodeMap<?, ?, ?> nodeMap;
        private List<TableViewerColumn> valueColumns = new ArrayList<TableViewerColumn>();
        private IPropertyItem selectedItem = null;
        private Set<IPropertyItem> delayedUpdate = new HashSet<IPropertyItem>();
        private boolean editing = false;

        public AnnotatedPropertyTab(String id, List<IPropertyItem> items) {
            this.contibutedItems = items;
        }

        public void createControl(Composite parent, ISessionContext context) {
            this.viewer = new TableViewer(parent, 65540);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.viewer.getTable());
            this.viewer.setContentProvider((IContentProvider)new PropertyItemContentsProvider());
            TableViewerColumn name = new TableViewerColumn(this.viewer, 16384);
            name.setLabelProvider((CellLabelProvider)new PropertyItemNameProvider());
            name.getColumn().setText("Property");
            name.getColumn().setWidth(200);
            name.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    PropertyItem item = AdaptationUtils.adaptToSingle(event.getSelection(), PropertyItem.class);
                    if (item != null) {
                        PropertyManipulator manipulator = (PropertyManipulator)manipulators.get(item);
                        int i = 0;
                        while (i < valueColumns.size()) {
                            TableViewerColumn c = (TableViewerColumn)valueColumns.get(i);
                            if (i < manipulator.getValueCount()) {
                                c.getColumn().setText(manipulator.getDescription(i));
                            } else {
                                c.getColumn().setText("");
                            }
                            ++i;
                        }
                    }
                }
            });
            this.viewer.getTable().setHeaderVisible(true);
            this.viewer.getTable().setLinesVisible(true);
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IPropertyItem item = AdaptationUtils.adaptToSingle(event.getSelection(), IPropertyItem.class);
                    selectedItem = item;
                    if (!((PropertyManipulator)manipulators.get(selectedItem)).getEditMode()) {
                        ((PropertyManipulator)manipulators.get(selectedItem)).setEditMode(true);
                    }
                    for (IPropertyItem i : delayedUpdate) {
                        if (i.equals(selectedItem)) continue;
                        ((PropertyManipulator)manipulators.get(i)).setEditMode(false);
                        viewer.update((Object)i, null);
                    }
                    if (delayedUpdate.contains(selectedItem)) {
                        delayedUpdate.clear();
                        delayedUpdate.add(selectedItem);
                    } else {
                        delayedUpdate.clear();
                    }
                }
            });
            CellNavigationStrategy nStrategy = new CellNavigationStrategy(){

                private ViewerCell internalFindSelectedCell(ColumnViewer viewer, ViewerCell currentSelectedCell, Event event) {
                    switch (event.keyCode) {
                        case 0x1000001: {
                            if (currentSelectedCell == null) break;
                            return AnnotatedPropertyTabContributorFactory.getNeighbor(currentSelectedCell, ViewerCell.ABOVE, false);
                        }
                        case 0x1000002: {
                            if (currentSelectedCell == null) break;
                            return AnnotatedPropertyTabContributorFactory.getNeighbor(currentSelectedCell, ViewerCell.BELOW, false);
                        }
                        case 0x1000003: {
                            if (currentSelectedCell == null) break;
                            return AnnotatedPropertyTabContributorFactory.getNeighbor(currentSelectedCell, ViewerCell.LEFT, true);
                        }
                        case 0x1000004: {
                            if (currentSelectedCell == null) break;
                            return AnnotatedPropertyTabContributorFactory.getNeighbor(currentSelectedCell, ViewerCell.RIGHT, true);
                        }
                    }
                    return null;
                }

                public ViewerCell findSelectedCell(ColumnViewer viewer, ViewerCell currentSelectedCell, Event event) {
                    ViewerCell cell = this.internalFindSelectedCell(viewer, currentSelectedCell, event);
                    if (cell != null) {
                        TableColumn t = viewer.getTable().getColumn(cell.getColumnIndex());
                        viewer.getTable().showColumn(t);
                    }
                    return cell;
                }
            };
            TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer));
            try {
                Field f = focusCellManager.getClass().getSuperclass().getDeclaredField("navigationStrategy");
                f.setAccessible(true);
                f.set(focusCellManager, nStrategy);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

                protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                    return event.eventType == 5 || event.eventType == 2 || event.eventType == 3 || event.eventType == 1 && (event.keyCode == 13 || event.keyCode == 0x100000B) || event.eventType == 4;
                }
            };
            TableViewerEditor.create(this.viewer, focusCellManager, actSupport, 58);
            this.viewer.getColumnViewerEditor().addEditorActivationListener(new ColumnViewerEditorActivationListener(){

                public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
                }

                public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
                }

                public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
                    ViewerCell cell = (ViewerCell)event.getSource();
                    viewer.getTable().showColumn(viewer.getTable().getColumn(cell.getColumnIndex()));
                }

                public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
                }
            });
        }

        public void setInput(ISessionContext context, ISelection selection, boolean force) {
            Collection<INode> nodes = AdaptationUtils.adaptToCollection(selection, INode.class);
            if (nodes.size() != 1) {
                if (this.node != null) {
                    this.node.removeListener(this);
                    this.node = null;
                }
                return;
            }
            INode n = nodes.iterator().next();
            if (this.node != null) {
                if (!this.node.equals(n)) {
                    this.node.removeListener(this);
                    this.setInput(n);
                }
            } else {
                this.setInput(n);
            }
        }

        private void setInput(INode node) {
            this.node = node;
            this.node.addListener(this);
            ParentNode<?> n = node;
            while (true) {
                if (n == null) {
                    this.nodeMap = null;
                    break;
                }
                if (n instanceof NodeMapProvider) {
                    this.nodeMap = ((NodeMapProvider)((Object)n)).getNodeMap();
                    if (this.nodeMap != null) break;
                }
                n = n.getParent();
            }
            boolean readOnly = node instanceof IStructuralNode && ((IStructuralNode)((Object)node)).isPartOfInstantiatedModel() && !((IStructuralNode)((Object)node)).isInstantiatedModelRoot();
            this.resolvedItems.clear();
            this.manipulators.clear();
            for (IPropertyItem item : this.contibutedItems) {
                if (item instanceof PropertyItem) {
                    this.resolvedItems.add((PropertyItem)item);
                    this.manipulators.put((PropertyItem)item, AnnotatedPropertyTabContributorFactory.createManipulator((PropertyItem)item, node));
                    continue;
                }
                if (item instanceof ComboPropertyItem) {
                    this.resolvedItems.add((ComboPropertyItem)item);
                    this.manipulators.put((ComboPropertyItem)item, AnnotatedPropertyTabContributorFactory.createManipulator((ComboPropertyItem)item, node));
                    continue;
                }
                if (!(item instanceof CompoundPropertyItem)) continue;
                CompoundPropertyItem compound = (CompoundPropertyItem)item;
                Map manipulators = AnnotatedPropertyTabContributorFactory.createManipulators(compound, node);
                for (PropertyItem i : manipulators.keySet()) {
                    this.resolvedItems.add(i);
                    this.manipulators.put(i, (PropertyManipulator)manipulators.get(i));
                }
            }
            int valueCount = 0;
            for (PropertyManipulator manipulator : this.manipulators.values()) {
                if (valueCount >= manipulator.getValueCount()) continue;
                valueCount = manipulator.getValueCount();
            }
            int i = 0;
            while (i < valueCount) {
                TableViewerColumn value = new TableViewerColumn(this.viewer, 16384);
                value.getColumn().setText("");
                value.getColumn().setWidth(200);
                this.valueColumns.add(value);
                ++i;
            }
            PropertyValueLabelProvider2 p = new PropertyValueLabelProvider2(this);
            int index = 0;
            for (TableViewerColumn c : this.valueColumns) {
                c.setLabelProvider((CellLabelProvider)p);
                if (readOnly) continue;
                PropertyEditingSupport support = new PropertyEditingSupport(this, this.viewer, index++, this.nodeMap);
                c.setEditingSupport((EditingSupport)support);
            }
            Collections.sort(this.resolvedItems, new Comparator<IPropertyItem>(){

                @Override
                public int compare(IPropertyItem o1, IPropertyItem o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            this.viewer.getTable().setEnabled(!readOnly);
            this.viewer.setInput(this.resolvedItems);
        }

        public void requestFocus() {
            this.viewer.getTable().forceFocus();
        }

        public void dispose() {
            if (this.node != null) {
                this.node.removeListener(this);
                this.node = null;
            }
        }

        public Control getControl() {
            return this.viewer.getTable();
        }

        public ISelectionProvider getSelectionProvider() {
            return null;
        }

        public boolean isDisposed() {
            return this.viewer.getTable().isDisposed();
        }

        @Override
        public <T extends INode> void nodeAdded(ParentNode<T> node, INode child, String rel) {
        }

        @Override
        public <T extends INode> void nodeRemoved(ParentNode<T> node, INode child, String rel) {
        }

        @Override
        public void propertyChanged(INode node, final String id) {
            if (Thread.currentThread() == Display.getDefault().getThread()) {
                if (this.viewer.getTable().isDisposed()) {
                    return;
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Viewer refresh " + id);
                }
                for (IPropertyItem item : this.resolvedItems) {
                    if (item.equals(this.selectedItem)) continue;
                    this.viewer.refresh((Object)item);
                }
                if (this.selectedItem != null) {
                    this.delayedUpdate.add(this.selectedItem);
                }
            } else if (!this.editing) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (viewer.getTable().isDisposed()) {
                            if (node != null) {
                                node.removeListener(this);
                            }
                            return;
                        }
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("Viewer threaded refresh " + id);
                        }
                        for (IPropertyItem item : resolvedItems) {
                            if (item.equals(selectedItem)) continue;
                            viewer.refresh((Object)item);
                        }
                        if (selectedItem != null) {
                            delayedUpdate.add(selectedItem);
                        }
                    }
                });
            } else {
                for (IPropertyItem item : this.resolvedItems) {
                    this.delayedUpdate.add(item);
                }
            }
        }

        public void updatePartName(Consumer<String> updateCallback) {
            if (this.node != null) {
                updateCallback.accept(this.node.toString());
            }
        }

        public PropertyManipulator getManipulator(IPropertyItem item) {
            return this.manipulators.get(item);
        }

        public void setEditing(boolean editing) {
            this.editing = editing;
        }
    }

    private static class AnnotatedPropertyTabContributor
    implements PropertyTabContributor {
        private String id;
        List<IPropertyItem> items;

        public AnnotatedPropertyTabContributor(String id, List<IPropertyItem> items) {
            if (id == null) {
                throw new NullPointerException();
            }
            this.id = id;
            this.items = items;
        }

        public IPropertyTab create(Composite parent, IWorkbenchSite site, ISessionContext context, Object input) {
            AnnotatedPropertyTab tab = new AnnotatedPropertyTab(this.id, this.items);
            tab.createControl(parent, context);
            return tab;
        }

        @Override
        public String getId() {
            return this.id;
        }
    }

    private static class ComboPropertyItem
    implements IPropertyItem {
        private String id;
        private String name;
        private String tabId;
        private Method getter;
        private Method setter;
        private Method values;
        private Class<? extends ComboPropertyManipulator> manipulatorClass;

        public ComboPropertyItem(String id) {
            if (id == null) {
                throw new NullPointerException();
            }
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        @Override
        public String getTabId() {
            return this.tabId;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean editable() {
            return this.setter != null;
        }
    }

    private static class CompoundPropertyItem
    implements IPropertyItem {
        private String id;
        private String name;
        private String tabId;
        private Method getter;
        private Method setter;
        private PropertyManipulatorFactory manipulatorFactory;

        public CompoundPropertyItem(String id) {
            if (id == null) {
                throw new NullPointerException();
            }
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        @Override
        public String getTabId() {
            return this.tabId;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean editable() {
            return this.setter != null;
        }
    }

    private static interface IPropertyItem {
        public String getTabId();

        public String getName();

        public String getId();

        public boolean editable();
    }

    private static class PropertyEditingSupport
    extends EditingSupport {
        AnnotatedPropertyTab tab;
        int index;
        NodeMap<?, ?, ?> nodeMap;
        TableViewer viewer;
        CellEditor propertyItemEditor;
        Map<ComboPropertyItem, CellEditor> comboEditors = new HashMap<ComboPropertyItem, CellEditor>();

        public PropertyEditingSupport(AnnotatedPropertyTab tab, TableViewer viewer, int index, NodeMap<?, ?, ?> nodeMap) {
            super((ColumnViewer)viewer);
            this.tab = tab;
            this.index = index;
            this.viewer = viewer;
            this.nodeMap = nodeMap;
        }

        protected boolean canEdit(Object element) {
            IPropertyItem item = (IPropertyItem)element;
            if (this.tab.getManipulator(item).getValueCount() <= this.index) {
                return false;
            }
            if (!item.editable()) {
                return false;
            }
            return this.getValue(element) != null;
        }

        protected CellEditor getCellEditor(Object element) {
            IPropertyItem item = (IPropertyItem)element;
            if (this.tab.getManipulator(item).getValueCount() <= this.index) {
                return null;
            }
            if (item instanceof PropertyItem) {
                if (this.propertyItemEditor == null) {
                    this.propertyItemEditor = new TextCellEditor((Composite)this.viewer.getTable(), 0){

                        public void activate() {
                            tab.setEditing(true);
                        }

                        public void deactivate() {
                            super.deactivate();
                            tab.setEditing(false);
                        }
                    };
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("CELL EDITOR: " + element);
                }
                return this.propertyItemEditor;
            }
            if (item instanceof ComboPropertyItem) {
                ComboPropertyItem comboPropertyItem = (ComboPropertyItem)item;
                Object editor = this.comboEditors.get(comboPropertyItem);
                if (editor == null) {
                    ComboPropertyManipulator manipulator = (ComboPropertyManipulator)this.tab.manipulators.get(comboPropertyItem);
                    editor = new ComboBoxCellEditor2((Composite)this.viewer.getTable(), manipulator.getItems(), 12){

                        public void activate() {
                            tab.setEditing(true);
                        }

                        public void deactivate() {
                            super.deactivate();
                            tab.setEditing(false);
                        }
                    };
                    this.comboEditors.put(comboPropertyItem, (CellEditor)editor);
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("CELL EDITOR: " + element);
                }
                return editor;
            }
            throw new IllegalStateException("Unsupported property item type " + item.getClass().getName());
        }

        protected Object getValue(Object element) {
            IPropertyItem item = (IPropertyItem)element;
            PropertyManipulator manipulator = this.tab.getManipulator(item);
            if (manipulator.getValueCount() <= this.index) {
                return null;
            }
            if (manipulator instanceof ComboPropertyManipulator) {
                return ((ComboPropertyManipulator)manipulator).getValueIndex();
            }
            String value = manipulator.getValue(this.index);
            return value;
        }

        protected void setValue(Object element, Object value) {
            IPropertyItem item = (IPropertyItem)element;
            PropertyManipulator manipulator = this.tab.getManipulator(item);
            if (manipulator.getValueCount() <= this.index) {
                throw new IllegalAccessError("Editing value in index " + this.index + " is not allowed.");
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("CELL SET VALUE: " + element + " " + value);
            }
            manipulator.setValue(value.toString(), this.index);
            this.viewer.refresh((Object)item);
            this.nodeMap.commit("Set " + item.getId() + " value to " + value);
        }
    }

    private static class PropertyItem
    implements IPropertyItem {
        private String id;
        private String name;
        private String tabId;
        private Method getter;
        private Method setter;
        private Class<? extends PropertyManipulator> manipulatorClass;

        public PropertyItem(String id) {
            if (id == null) {
                throw new NullPointerException();
            }
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        @Override
        public String getTabId() {
            return this.tabId;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean editable() {
            return this.setter != null;
        }
    }

    private static class PropertyItemContentsProvider
    implements IStructuredContentProvider {
        private PropertyItemContentsProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List items = (List)inputElement;
            return items.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class PropertyItemNameProvider
    extends CellLabelProvider {
        private PropertyItemNameProvider() {
        }

        public void update(ViewerCell cell) {
            IPropertyItem item = (IPropertyItem)cell.getElement();
            if (item.getName().length() > 0) {
                cell.setText(item.getName());
            } else {
                cell.setText(item.getId());
            }
        }
    }

    private static class PropertyValueLabelProvider2
    extends CellLabelProvider {
        AnnotatedPropertyTab tab;

        public PropertyValueLabelProvider2(AnnotatedPropertyTab tab) {
            this.tab = tab;
        }

        public void update(ViewerCell cell) {
            IPropertyItem item = (IPropertyItem)cell.getElement();
            int index = cell.getColumnIndex() - 1;
            PropertyManipulator manipulator = this.tab.getManipulator(item);
            if (manipulator.getValueCount() <= index) {
                return;
            }
            cell.setText(manipulator.getValue(index));
        }
    }

    public static class TableViewerEditor
    extends ColumnViewerEditor {
        private TableEditor tableEditor;
        private TableViewerFocusCellManager focusCellManager;
        private int feature;

        TableViewerEditor(TableViewer viewer, TableViewerFocusCellManager focusCellManager, ColumnViewerEditorActivationStrategy editorActivationStrategy, int feature) {
            super((ColumnViewer)viewer, editorActivationStrategy, feature);
            this.feature = feature;
            this.tableEditor = new TableEditor(viewer.getTable());
            this.focusCellManager = focusCellManager;
        }

        public static void create(TableViewer viewer, TableViewerFocusCellManager focusCellManager, ColumnViewerEditorActivationStrategy editorActivationStrategy, int feature) {
            TableViewerEditor editor = new TableViewerEditor(viewer, focusCellManager, editorActivationStrategy, feature);
            viewer.setColumnViewerEditor((ColumnViewerEditor)editor);
            if (focusCellManager != null) {
                try {
                    Method m = focusCellManager.getClass().getSuperclass().getDeclaredMethod("init", new Class[0]);
                    m.setAccessible(true);
                    m.invoke((Object)focusCellManager, new Object[0]);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }

        public static void create(TableViewer viewer, ColumnViewerEditorActivationStrategy editorActivationStrategy, int feature) {
            TableViewerEditor.create(viewer, null, editorActivationStrategy, feature);
        }

        protected void setEditor(Control w, Item item, int columnNumber) {
            this.tableEditor.setEditor(w, (TableItem)item, columnNumber);
        }

        protected void setLayoutData(CellEditor.LayoutData layoutData) {
            this.tableEditor.grabHorizontal = layoutData.grabHorizontal;
            this.tableEditor.horizontalAlignment = layoutData.horizontalAlignment;
            this.tableEditor.minimumWidth = layoutData.minimumWidth;
        }

        public ViewerCell getFocusCell() {
            if (this.focusCellManager != null) {
                return this.focusCellManager.getFocusCell();
            }
            return super.getFocusCell();
        }

        protected void updateFocusCell(ViewerCell focusCell, ColumnViewerEditorActivationEvent event) {
            if ((event.eventType == 4 || event.eventType == 5) && this.focusCellManager != null) {
                try {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("FOCUS CELL: " + focusCell);
                    }
                    Method m = AbstractTableViewer.class.getDeclaredMethod("getSelectionFromWidget", new Class[0]);
                    m.setAccessible(true);
                    List l = (List)m.invoke((Object)this.getViewer(), new Object[0]);
                    if (this.focusCellManager != null) {
                        m = this.focusCellManager.getClass().getSuperclass().getDeclaredMethod("setFocusCell", ViewerCell.class);
                        m.setAccessible(true);
                        m.invoke((Object)this.focusCellManager, focusCell);
                    }
                    if (!l.contains(focusCell.getElement())) {
                        this.getViewer().setSelection((ISelection)new StructuredSelection(focusCell.getElement()));
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }

        protected void processTraverseEvent(int columnIndex, ViewerRow row, TraverseEvent event) {
            ViewerCell cell2edit = null;
            if (event.detail == 8) {
                event.doit = false;
                if ((event.stateMask & 0x40000) == 262144 && (this.feature & 8) == 8) {
                    cell2edit = this.searchCellAboveBelow(row, this.getViewer(), columnIndex, true);
                } else if ((this.feature & 0x10) == 16) {
                    cell2edit = this.searchPreviousCell(row, row.getCell(columnIndex), row.getCell(columnIndex), this.getViewer());
                }
            } else if (event.detail == 16) {
                event.doit = false;
                if ((event.stateMask & 0x40000) == 262144 && (this.feature & 8) == 8) {
                    cell2edit = this.searchCellAboveBelow(row, this.getViewer(), columnIndex, false);
                } else if ((this.feature & 0x10) == 16) {
                    cell2edit = this.searchNextCell(row, row.getCell(columnIndex), row.getCell(columnIndex), this.getViewer());
                }
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("NEXT CELL: " + cell2edit);
            }
            if (cell2edit != null) {
                this.getViewer().getControl().setRedraw(false);
                ColumnViewerEditorActivationEvent acEvent = new ColumnViewerEditorActivationEvent(cell2edit, event);
                try {
                    Method m = ColumnViewer.class.getDeclaredMethod("triggerEditorActivationEvent", ColumnViewerEditorActivationEvent.class);
                    m.setAccessible(true);
                    m.invoke((Object)this.getViewer(), acEvent);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                this.getViewer().getControl().setRedraw(true);
            }
        }

        private ViewerCell searchCellAboveBelow(ViewerRow row, ColumnViewer viewer, int columnIndex, boolean above) {
            ViewerCell rv = null;
            ViewerRow newRow = null;
            newRow = above ? row.getNeighbor(1, false) : row.getNeighbor(2, false);
            try {
                if (newRow != null) {
                    Method m = ColumnViewer.class.getDeclaredMethod("getViewerColumn", Integer.TYPE);
                    m.setAccessible(true);
                    ViewerColumn column = (ViewerColumn)m.invoke((Object)viewer, new Integer(columnIndex));
                    m = ViewerColumn.class.getDeclaredMethod("getEditingSupport", new Class[0]);
                    m.setAccessible(true);
                    EditingSupport es = (EditingSupport)m.invoke((Object)column, new Object[0]);
                    if (column != null && es != null) {
                        m = EditingSupport.class.getDeclaredMethod("canEdit", Object.class);
                        m.setAccessible(true);
                        Boolean b = (Boolean)m.invoke((Object)es, newRow.getItem().getData());
                        if (b.booleanValue()) {
                            rv = newRow.getCell(columnIndex);
                        }
                    } else {
                        rv = this.searchCellAboveBelow(newRow, viewer, columnIndex, above);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return rv;
        }

        private ViewerCell searchPreviousCell(ViewerRow row, ViewerCell currentCell, ViewerCell originalCell, ColumnViewer viewer) {
            ViewerRow rowAbove;
            ViewerCell rv = null;
            ViewerCell previousCell = currentCell != null ? AnnotatedPropertyTabContributorFactory.getNeighbor(currentCell, ViewerCell.LEFT, true) : (row.getColumnCount() != 0 ? row.getCell(AnnotatedPropertyTabContributorFactory.getCreationIndex(row, row.getColumnCount() - 1)) : row.getCell(0));
            if (originalCell.equals((Object)previousCell)) {
                return null;
            }
            if (previousCell != null) {
                rv = this.isCellEditable(viewer, previousCell) ? previousCell : this.searchPreviousCell(row, previousCell, originalCell, viewer);
            } else if ((this.feature & 4) == 4) {
                rv = this.searchPreviousCell(row, null, originalCell, viewer);
            } else if ((this.feature & 2) == 2 && (rowAbove = row.getNeighbor(1, false)) != null) {
                rv = this.searchPreviousCell(rowAbove, null, originalCell, viewer);
            }
            return rv;
        }

        private ViewerCell searchNextCell(ViewerRow row, ViewerCell currentCell, ViewerCell originalCell, ColumnViewer viewer) {
            ViewerRow rowBelow;
            ViewerCell rv = null;
            ViewerCell nextCell = currentCell != null ? AnnotatedPropertyTabContributorFactory.getNeighbor(currentCell, ViewerCell.RIGHT, true) : row.getCell(AnnotatedPropertyTabContributorFactory.getCreationIndex(row, 0));
            if (originalCell.equals((Object)nextCell)) {
                return null;
            }
            if (nextCell != null) {
                rv = this.isCellEditable(viewer, nextCell) ? nextCell : this.searchNextCell(row, nextCell, originalCell, viewer);
            } else if ((this.feature & 4) == 4) {
                rv = this.searchNextCell(row, null, originalCell, viewer);
            } else if ((this.feature & 2) == 2 && (rowBelow = row.getNeighbor(2, false)) != null) {
                rv = this.searchNextCell(rowBelow, null, originalCell, viewer);
            }
            return rv;
        }

        private boolean isCellEditable(ColumnViewer viewer, ViewerCell cell) {
            try {
                Method m = ColumnViewer.class.getDeclaredMethod("getViewerColumn", Integer.TYPE);
                m.setAccessible(true);
                ViewerColumn column = (ViewerColumn)m.invoke((Object)viewer, new Integer(cell.getColumnIndex()));
                m = ViewerColumn.class.getDeclaredMethod("getEditingSupport", new Class[0]);
                m.setAccessible(true);
                EditingSupport es = (EditingSupport)m.invoke((Object)column, new Object[0]);
                if (column != null && es != null) {
                    m = EditingSupport.class.getDeclaredMethod("canEdit", Object.class);
                    m.setAccessible(true);
                    Boolean b = (Boolean)m.invoke((Object)es, cell.getElement());
                    return b;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }
    }
}

