/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.rpcexperiment.ontology;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.QueryControl;

public class FMIRPCResource {
    public final Resource Experiment;
    public final Resource Experiment_Run;

    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        }
        catch (DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public FMIRPCResource(ReadGraph graph) {
        this.Experiment = FMIRPCResource.getResourceOrNull(graph, "http://www.simantics.org/FMI-RPC-1.0/Experiment");
        this.Experiment_Run = FMIRPCResource.getResourceOrNull(graph, "http://www.simantics.org/FMI-RPC-1.0/Experiment/Run");
    }

    public static FMIRPCResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        FMIRPCResource ret = (FMIRPCResource)session.peekService(FMIRPCResource.class);
        if (ret == null) {
            QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
            ret = new FMIRPCResource(qc.getIndependentGraph(graph));
            session.registerService(FMIRPCResource.class, (Object)ret);
        }
        return ret;
    }

    public static FMIRPCResource getInstance(RequestProcessor session) throws DatabaseException {
        FMIRPCResource ret = (FMIRPCResource)session.peekService(FMIRPCResource.class);
        if (ret == null) {
            ret = (FMIRPCResource)session.syncRequest((Read)new Read<FMIRPCResource>(){

                public FMIRPCResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
                    return new FMIRPCResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(FMIRPCResource.class, (Object)ret);
        }
        return ret;
    }

    public static class URIs {
        public static final String Experiment = "http://www.simantics.org/FMI-RPC-1.0/Experiment";
        public static final String Experiment_Run = "http://www.simantics.org/FMI-RPC-1.0/Experiment/Run";
    }
}

