/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.route.internal;

import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.ReadInterface;
import org.simantics.district.route.Route;
import org.simantics.district.route.internal.RouteImpl;
import org.simantics.district.route.internal.RoutePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutePersistenceJob
extends DatabaseJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutePersistenceJob.class);
    private RouteImpl route;
    private int eventType;
    private CompletableFuture<Route> future;

    public RoutePersistenceJob(RouteImpl route, int eventType, CompletableFuture<Route> future) {
        super("Route Persistence");
        this.route = route;
        this.eventType = eventType;
        this.future = future;
        this.setUser(false);
        this.setSystem(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            Simantics.getSession().syncRequest(graph -> this.persist(graph));
            this.future.complete(this.route);
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to persist route {}", (Object)this.route, (Object)e);
            this.future.completeExceptionally(e);
        }
        return Status.OK_STATUS;
    }

    private void persist(WriteGraph graph) throws DatabaseException {
        switch (this.eventType) {
            case 5: {
                this.remove(graph);
                break;
            }
            case 9: {
                this.write(graph);
            }
        }
    }

    private void write(WriteGraph graph) throws DatabaseException {
        graph.markUndoPoint();
        Resource r = this.route.backend();
        Resource me = this.route.modelEntity();
        if (r == null) {
            Resource model = (Resource)graph.sync((ReadInterface)new PossibleModel(me));
            this.route.backend(RoutePersistence.createRoute(graph, model, this.route.getName(), RoutePersistence.toResources(this.route.waypoints())));
        } else {
            RoutePersistence.updateRoute(graph, r, this.route.getName(), RoutePersistence.toResources(this.route.waypoints()));
        }
    }

    private void remove(WriteGraph graph) throws DatabaseException {
        graph.markUndoPoint();
        Resource r = this.route.backend();
        if (r != null) {
            RoutePersistence.removeRoute(graph, r);
        }
    }
}

