/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.techtype.table;

import java.util.Set;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.district.network.techtype.TechTypeValidationUtils;
import org.simantics.district.network.ui.techtype.table.TechTypeTableView;
import org.simantics.utils.ui.ExceptionUtils;

public class ValidateTechTypeTableHandler {
    @CanExecute
    public boolean canExecute() {
        return TechTypeTableView.table != null && TechTypeTableView.table.getCurrentTable() != null && TechTypeTableView.table.getComponentType() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell s) {
        Set result;
        Resource table = TechTypeTableView.table.getCurrentTable();
        if (table == null) {
            return;
        }
        try {
            result = TechTypeValidationUtils.validateTechTypeTable((Resource)table);
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((String)"Tech type table validation failed", (Throwable)e);
            return;
        }
        TechTypeTableView.table.setValidationResult(result);
        MessageDialog.openInformation((Shell)s, (String)"Validation result", (String)(result.isEmpty() ? "No invalid values found" : String.valueOf(result.size()) + " invalid values found"));
    }
}

