/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.techtype.table;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.techtype.table.TechTypeTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TechTypeTableView {
    private static final Logger LOGGER = LoggerFactory.getLogger(TechTypeTableView.class);
    public static final String ID = "org.simantics.district.network.ui.techtype.table.techtypeTableView";
    @Inject
    ESelectionService selectionService;
    public static TechTypeTable table;
    private static Resource tableToOpen;

    static {
        tableToOpen = null;
    }

    @Inject
    public void init(MPart part, MApplication app) {
        MToolBar toolBar = MMenuFactory.INSTANCE.createToolBar();
        toolBar.setToBeRendered(true);
        toolBar.getChildren().add(this.createImportCSVDataToolItem(app));
        toolBar.getChildren().add(this.createValidateTableToolItem(app));
        toolBar.getChildren().add(this.createResetComponentsItem(app));
        part.setToolbar(toolBar);
    }

    private MHandledToolItem createValidateTableToolItem(MApplication app) {
        MHandledToolItem createHandledToolItem = MMenuFactory.INSTANCE.createHandledToolItem();
        MCommand command = app.getCommand("org.simantics.district.network.ui.command.validatetechtypetable");
        createHandledToolItem.setCommand(command);
        createHandledToolItem.setLabel("Validate Tech Type Table");
        createHandledToolItem.setIconURI("platform:/plugin/com.famfamfam.silk/icons/accept.png");
        return createHandledToolItem;
    }

    private MHandledToolItem createImportCSVDataToolItem(MApplication app) {
        MHandledToolItem createHandledToolItem = MMenuFactory.INSTANCE.createHandledToolItem();
        MCommand command = app.getCommand("org.simantics.district.network.ui.command.importtechtypecsv");
        createHandledToolItem.setCommand(command);
        createHandledToolItem.setLabel("Import Tech Type");
        createHandledToolItem.setIconURI("platform:/plugin/com.famfamfam.silk/icons/table_edit.png");
        return createHandledToolItem;
    }

    private MToolBarElement createResetComponentsItem(MApplication app) {
        MHandledToolItem createHandledToolItem = MMenuFactory.INSTANCE.createHandledToolItem();
        MCommand command = app.getCommand("org.simantics.district.network.ui.command.resetcomponentproperties");
        createHandledToolItem.setCommand(command);
        createHandledToolItem.setLabel("Reset Component Properties");
        createHandledToolItem.setIconURI("platform:/plugin/com.famfamfam.silk/icons/database_go.png");
        return createHandledToolItem;
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        Resource componentType = null;
        try {
            if (tableToOpen == null) {
                List componentTypes = DistrictNetworkUtil.getDistrictComponents();
                componentType = componentTypes.stream().filter(r -> r.getName().toLowerCase().contains("pipe")).map(r -> r.getResource()).findFirst().orElse(null);
                LOGGER.debug("Pipe component type is {}", (Object)componentType);
            } else {
                componentType = (Resource)Simantics.getSession().syncRequest((Read)new ResourceRead<Resource>(tableToOpen){

                    public Resource perform(ReadGraph graph) throws DatabaseException {
                        return graph.getPossibleObject(this.resource, DistrictNetworkResource.getInstance((ReadGraph)graph).TechType_TechTypeTable_HasComponentType);
                    }
                });
            }
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to read district component types for active model", (Throwable)e);
        }
        table = new TechTypeTable(parent, 0, componentType);
        if (tableToOpen != null && componentType == null) {
            TechTypeTableView.openTechTypeTable(tableToOpen);
        }
        tableToOpen = null;
    }

    @PreDestroy
    public void dispose() {
        table.dispose();
        table = null;
    }

    public static void openTechTypeTable(final Resource tableResource) {
        if (table == null) {
            IEclipseContext eclipseContext = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
            if (eclipseContext == null) {
                LOGGER.error("No Eclipse context available");
                return;
            }
            EPartService partService = (EPartService)(eclipseContext = eclipseContext.getActiveLeaf()).get(EPartService.class);
            if (partService == null) {
                return;
            }
            tableToOpen = tableResource;
            partService.showPart(ID, EPartService.PartState.ACTIVATE);
        } else {
            try {
                Simantics.getSession().syncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                        Resource componentType = graph.getPossibleObject(tableResource, DN.TechType_TechTypeTable_HasComponentType);
                        if (componentType != null) {
                            table.getDisplay().asyncExec(() -> table.setComponentType(componentType));
                        } else {
                            String data = (String)graph.getRelatedValue2(tableResource, DN.TechType_TechTypeTable_HasData);
                            table.getDisplay().asyncExec(() -> {
                                table.setComponentType(null);
                                table.setTechTypeData(data, null);
                            });
                        }
                    }
                });
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to read tech type table {}", (Object)table, (Object)e);
            }
        }
    }
}

