/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.techtype.table;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.simantics.district.network.ui.techtype.table.TechTypeTableDataProvider;
import org.simantics.utils.strings.AlphanumComparator;

public class TechTypeTableSortModel
implements ISortModel {
    protected int currentSortColumn = -1;
    protected SortDirectionEnum currentSortDirection = SortDirectionEnum.ASC;
    private TechTypeTableDataProvider bodyDataProvider;

    public TechTypeTableSortModel(TechTypeTableDataProvider bodyDataProvider) {
        this.bodyDataProvider = bodyDataProvider;
    }

    public List<Integer> getSortedColumnIndexes() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        if (this.currentSortColumn > -1) {
            indexes.add(this.currentSortColumn);
        }
        return indexes;
    }

    public boolean isColumnIndexSorted(int columnIndex) {
        return columnIndex == this.currentSortColumn && !this.currentSortDirection.equals((Object)SortDirectionEnum.NONE);
    }

    public SortDirectionEnum getSortDirection(int columnIndex) {
        return columnIndex == this.currentSortColumn ? this.currentSortDirection : SortDirectionEnum.NONE;
    }

    public int getSortOrder(int columnIndex) {
        return 0;
    }

    public List<Comparator> getComparatorsForColumnIndex(int columnIndex) {
        return Collections.singletonList(AlphanumComparator.COMPARATOR);
    }

    public Comparator<?> getColumnComparator(int columnIndex) {
        return AlphanumComparator.COMPARATOR;
    }

    public void sort(int columnIndex, SortDirectionEnum sortDirection, boolean accumulate) {
        if (!this.isColumnIndexSorted(columnIndex)) {
            this.clear();
        }
        this.currentSortColumn = columnIndex;
        this.currentSortDirection = sortDirection;
        this.bodyDataProvider.sortBy(columnIndex, sortDirection);
    }

    public void clear() {
        this.currentSortColumn = -1;
        this.currentSortDirection = SortDirectionEnum.NONE;
    }

    public static <T> T[] ensureArraySize(T[] array, int l, Class<T> clazz, T defaultValue) {
        boolean fill = true;
        if (array == null || array.length != l) {
            array = (Object[])Array.newInstance(clazz, l);
            boolean bl = fill = defaultValue != null;
        }
        if (fill) {
            Arrays.fill(array, defaultValue);
        }
        return array;
    }
}

