/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.techtype.table;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.EditableRule;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.CheckBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.freeze.CompositeFreezeLayer;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeLayer;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.reorder.RowReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.techtype.requests.EnableTechTypeItem;
import org.simantics.district.network.techtype.requests.PossibleTechTypeKeyName;
import org.simantics.district.network.techtype.requests.PossibleTechTypeTable;
import org.simantics.district.network.techtype.requests.WriteTechTypeTable;
import org.simantics.district.network.ui.techtype.table.TechTypeColumnHeaderTableDataProvider;
import org.simantics.district.network.ui.techtype.table.TechTypeRowHeaderTableDataProvider;
import org.simantics.district.network.ui.techtype.table.TechTypeTableDataProvider;
import org.simantics.district.network.ui.techtype.table.TechTypeTableSortModel;
import org.simantics.utils.datastructures.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TechTypeTable
extends Composite {
    private static final CheckBoxCellEditor CHECK_BOX_CELL_EDITOR = new CheckBoxCellEditor();
    private static final CheckBoxPainter CHECK_BOX_PAINTER = new CheckBoxPainter();
    private static final String INVALID_LABEL = "INVALID";
    protected static final String CHECK_BOX_LABEL = "CHECK_BOX";
    private static final Logger LOGGER = LoggerFactory.getLogger(TechTypeTable.class);
    NatTable table;
    private TechTypeTableDataProvider bodyDataProvider;
    DataLayer bodyDataLayer;
    private IConfigRegistry summaryConfigRegistry;
    private IUniqueIndexLayer summaryRowLayer;
    private ViewportLayer viewportLayer;
    private CompositeFreezeLayer compositeFreezeLayer;
    private FreezeLayer freezeLayer;
    private ColumnHideShowLayer columnHideShowLayer;
    private ColumnGroupModel columnGroupModel = new ColumnGroupModel();
    private TechTypeColumnHeaderTableDataProvider columnHeaderDataProvider;
    Clipboard cpb;
    public SelectionLayer selectionLayer;
    private TechTypeTableSortModel sortModel;
    private Resource componentType;
    private Resource tableResource = null;
    private String keyName;
    protected Set<String> validationResult;

    public TechTypeTable(Composite parent, int style, Resource componentType) {
        super(parent, style);
        this.componentType = componentType;
        this.defaultInitializeUI();
    }

    private void defaultInitializeUI() {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo((Composite)this);
        Composite filterComposite = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)filterComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(filterComposite);
        this.createFilterBar(filterComposite);
        Composite tableComposite = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(tableComposite);
        this.createTable(tableComposite);
    }

    private void createFilterBar(Composite filterComposite) {
        final Text filterText = new Text(filterComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)filterText);
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                System.out.println("text modified");
                TechTypeTable.this.bodyDataProvider.setFilter(filterText.getText());
                TechTypeTable.this.table.refresh(true);
            }
        });
    }

    private void createTable(Composite parent) {
        String data = null;
        int[] enabled = null;
        if (this.componentType != null) {
            try {
                Triple tableData = (Triple)Simantics.getSession().syncRequest((Read)new TableDataRequest(this.componentType), (Listener)new TableDataListener(this.componentType));
                if (tableData != null) {
                    this.tableResource = (Resource)tableData.first;
                    data = (String)tableData.second;
                    enabled = ((List)tableData.third).stream().mapToInt(Integer::intValue).toArray();
                } else {
                    this.tableResource = null;
                }
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to read tech type table data for {}", (Object)this.componentType, (Object)e);
            }
        }
        this.bodyDataProvider = new TechTypeTableDataProvider(data, enabled);
        this.bodyDataLayer = new DataLayer((IDataProvider)this.bodyDataProvider);
        this.bodyDataLayer.setConfigLabelAccumulator(new IConfigLabelAccumulator(){

            public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
                int keyColumn;
                if (TechTypeTable.this.bodyDataProvider.isCheckBoxColumn(columnPosition)) {
                    configLabels.addLabel(TechTypeTable.CHECK_BOX_LABEL);
                } else if (TechTypeTable.this.validationResult != null && TechTypeTable.this.keyName != null && (keyColumn = TechTypeTable.this.bodyDataProvider.getVariableIndex(TechTypeTable.this.keyName)) >= 0) {
                    String key = (String)TechTypeTable.this.bodyDataProvider.getDataValue(keyColumn, rowPosition);
                    String columnName = TechTypeTable.this.bodyDataProvider.getVariableName(columnPosition);
                    if (TechTypeTable.this.validationResult.contains(String.valueOf(key) + "/" + columnName)) {
                        configLabels.addLabel(TechTypeTable.INVALID_LABEL);
                    }
                }
            }
        });
        this.bodyDataProvider.addEnableListener((rowIndex, enable) -> {
            if (this.tableResource != null) {
                try {
                    Simantics.getSession().syncRequest((Write)new EnableTechTypeItem(this.tableResource, rowIndex, enable));
                }
                catch (DatabaseException e) {
                    LOGGER.error("Failed to update enable state for {}", (Object)this.tableResource, (Object)e);
                }
            }
        });
        this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)this.bodyDataLayer);
        RowReorderLayer rowReorderLayer = new RowReorderLayer((IUniqueIndexLayer)this.columnHideShowLayer);
        this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)rowReorderLayer);
        this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
        this.viewportLayer.setRegionName("BODY");
        this.freezeLayer = new FreezeLayer((IUniqueIndexLayer)this.selectionLayer);
        this.compositeFreezeLayer = new CompositeFreezeLayer(this.freezeLayer, this.viewportLayer, this.selectionLayer);
        this.columnHeaderDataProvider = new TechTypeColumnHeaderTableDataProvider(this.bodyDataProvider);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)this.columnHeaderDataProvider);
        columnHeaderDataLayer.setRowsResizableByDefault(false);
        columnHeaderDataLayer.setColumnsResizableByDefault(true);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)this.compositeFreezeLayer, this.selectionLayer);
        ColumnGroupHeaderLayer columnGroupHeaderLayer = new ColumnGroupHeaderLayer((ILayer)columnHeaderLayer, this.selectionLayer, this.columnGroupModel);
        columnGroupHeaderLayer.setCalculateHeight(true);
        this.sortModel = new TechTypeTableSortModel(this.bodyDataProvider);
        SortHeaderLayer columnSortHeaderLayer = new SortHeaderLayer((ILayer)columnGroupHeaderLayer, (ISortModel)this.sortModel);
        TechTypeRowHeaderTableDataProvider rowHeaderDataProvider = new TechTypeRowHeaderTableDataProvider(this.bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        rowHeaderDataLayer.setRowsResizableByDefault(false);
        rowHeaderDataLayer.setColumnsResizableByDefault(false);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)this.compositeFreezeLayer, this.selectionLayer);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)this.columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnSortHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)this.compositeFreezeLayer, (ILayer)columnSortHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        this.table = new NatTable(parent, 538184448, (ILayer)gridLayer, false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.table);
        this.table.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        this.table.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                Style cellStyle = new Style();
                cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_RED);
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)new EditableRule(){

                    public boolean isEditable(int columnIndex, int rowIndex) {
                        return TechTypeTable.this.bodyDataProvider.isEditable(columnIndex, rowIndex);
                    }
                });
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", TechTypeTable.INVALID_LABEL);
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)CHECK_BOX_CELL_EDITOR, "EDIT", TechTypeTable.CHECK_BOX_LABEL);
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)CHECK_BOX_PAINTER, "NORMAL", TechTypeTable.CHECK_BOX_LABEL);
            }
        });
        CopyDataCommandHandler copyHandler = new CopyDataCommandHandler(this.selectionLayer, (ILayer)columnHeaderDataLayer, (ILayer)rowHeaderDataLayer);
        copyHandler.setCopyFormattedText(true);
        gridLayer.registerCommandHandler((ILayerCommandHandler)copyHandler);
        this.cpb = new Clipboard(this.getDisplay());
        this.table.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        this.table.configure();
    }

    private static String getKeyColumnName(Resource componentType) {
        String keyName = null;
        if (componentType != null) {
            try {
                keyName = (String)Simantics.getSession().syncRequest((Read)new PossibleTechTypeKeyName(componentType));
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to read possible tech type key name for {}", (Object)componentType, (Object)e);
            }
        }
        return keyName != null && keyName.startsWith("_") ? keyName.substring(1) : keyName;
    }

    public void dispose() {
        this.cpb.dispose();
        super.dispose();
    }

    public Resource getComponentType() {
        return this.componentType;
    }

    public void setComponentType(Resource componentType) {
        if (Objects.equals(this.componentType, componentType)) {
            return;
        }
        this.componentType = componentType;
        this.keyName = TechTypeTable.getKeyColumnName(componentType);
        if (componentType != null) {
            Simantics.getSession().asyncRequest((Read)new TableDataRequest(componentType), (Listener)new TableDataListener(componentType));
        }
    }

    public void setTechTypePath(String path) {
        String data;
        try {
            data = Files.lines(Paths.get(path, new String[0]), Charset.defaultCharset()).collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            LOGGER.error("Failed to read contents of file '{}' as {}", new Object[]{path, Charset.defaultCharset(), e});
            return;
        }
        try {
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    graph.syncRequest((Write)new WriteTechTypeTable(TechTypeTable.this.componentType, data));
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to write tech type table data to model", (Throwable)e);
        }
        this.setComponentType(this.componentType);
    }

    public void setTechTypeData(String data, int[] enabled) {
        this.bodyDataProvider.setData(data);
        this.bodyDataProvider.setEnabledFlags(enabled);
        this.table.refresh(true);
    }

    public void setValidationResult(Set<String> result) {
        if (result != null && result.isEmpty()) {
            result = null;
        }
        this.validationResult = result;
        if (result != null) {
            this.keyName = TechTypeTable.getKeyColumnName(this.componentType);
        }
        this.table.refresh();
    }

    public Resource getCurrentTable() {
        return this.tableResource;
    }

    private final class TableDataListener
    implements Listener<Triple<Resource, String, List<Integer>>> {
        private final Resource componentType;

        private TableDataListener(Resource componentType) {
            this.componentType = componentType;
        }

        public void execute(Triple<Resource, String, List<Integer>> result) {
            TechTypeTable.this.getDisplay().asyncExec(() -> {
                if (this.isDisposed() || result == null) {
                    return;
                }
                TechTypeTable.this.tableResource = (Resource)triple.first;
                String data = (String)triple.second;
                int[] enabled = ((List)triple.third).stream().mapToInt(Integer::intValue).toArray();
                TechTypeTable.this.setTechTypeData(data, enabled);
                TechTypeTable.this.setValidationResult(null);
            });
        }

        public void exception(Throwable t) {
            LOGGER.error("Error updating tech type table data for {}", (Object)this.componentType, (Object)t);
        }

        public boolean isDisposed() {
            return TechTypeTable.this.table != null && TechTypeTable.this.table.isDisposed() || !Objects.equals(TechTypeTable.this.componentType, this.componentType);
        }
    }

    private final class TableDataRequest
    extends ResourceRead<Triple<Resource, String, List<Integer>>> {
        private TableDataRequest(Resource componentType) {
            super(componentType);
        }

        public Triple<Resource, String, List<Integer>> perform(ReadGraph graph) throws DatabaseException {
            Resource model = (Resource)graph.syncRequest((Read)new PossibleActiveModel(Simantics.getProjectResource()));
            if (model == null) {
                return null;
            }
            Resource tableResource = (Resource)graph.syncRequest((Read)new PossibleTechTypeTable(model, this.resource));
            if (tableResource == null) {
                return null;
            }
            String data = (String)graph.getRelatedValue2(tableResource, DistrictNetworkResource.getInstance((ReadGraph)graph).TechType_TechTypeTable_HasData);
            int[] enabled = (int[])graph.getRelatedValue2(tableResource, DistrictNetworkResource.getInstance((ReadGraph)graph).TechType_TechTypeTable_HasEnabledItems);
            List list = Arrays.stream(enabled).mapToObj(Integer::valueOf).collect(Collectors.toList());
            return Triple.make((Object)tableResource, (Object)data, list);
        }
    }
}

