/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.techtype.table;

import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.district.network.techtype.TechTypeUtils;
import org.simantics.district.network.ui.techtype.table.TechTypeTableView;
import org.simantics.utils.ui.ExceptionUtils;

public class ResetComponentsHandler {
    @CanExecute
    public boolean canExecute() {
        return TechTypeTableView.table != null && TechTypeTableView.table.getCurrentTable() != null && TechTypeTableView.table.getComponentType() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell s) {
        Resource table = TechTypeTableView.table.getCurrentTable();
        if (table == null) {
            return;
        }
        boolean result = MessageDialog.openConfirm(null, (String)"Confirmation", (String)"Do you really want to reset all component properties to values in this table?");
        if (!result) {
            return;
        }
        try {
            TechTypeUtils.resetComponents((Resource)table);
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((String)"Error resetting components.", (Throwable)e);
        }
    }
}

