/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.techtype;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.techtype.requests.TechTypeTableData;
import org.simantics.district.network.ui.techtype.PossibleTechTypeKeyPredicate;
import org.simantics.modeling.adapters.ExistingInstancesRemover;
import org.simantics.modeling.adapters.RemoveInstancesDialog;
import org.simantics.utils.strings.AlphanumComparator;

public class TechTypeTableRemover
extends ExistingInstancesRemover {
    public TechTypeTableRemover(Resource resource) {
        super(resource, "Tech Type Table");
    }

    public void remove(WriteGraph graph) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Resource componentType = graph.getPossibleObject(this.resource, DN.TechType_TechTypeTable_HasComponentType);
        if (componentType == null) {
            this.justRemove(graph);
            return;
        }
        super.remove(graph, this.resource, componentType, componentType);
    }

    protected Set<Resource> discoverInstances(WriteGraph graph, Resource componentType) throws DatabaseException {
        Resource keyPredicate = (Resource)graph.syncRequest((Read)new PossibleTechTypeKeyPredicate(componentType), (Listener)TransientCacheListener.instance());
        if (keyPredicate == null) {
            return Collections.emptySet();
        }
        Map data = (Map)graph.syncRequest((Read)new TechTypeTableData(this.resource), (Listener)TransientCacheListener.instance());
        HashSet<Resource> used = new HashSet<Resource>();
        for (Resource comp : super.discoverInstances(graph, componentType)) {
            Object code = graph.getPossibleRelatedValue(comp, keyPredicate);
            if (code == null || !(code instanceof String) || !data.containsKey(code)) continue;
            used.add(comp);
        }
        return used;
    }

    protected void confirmRemoval(WriteGraph graph, final Set<Resource> instances, final String typeDescription, final String typeName) throws DatabaseException {
        Map instanceAddresses = this.resolveInstanceAddresses((ReadGraph)graph, instances);
        final RemoveInstancesDialog.Content[] content = new RemoveInstancesDialog.Content[instanceAddresses.size()];
        int i = 0;
        for (Map.Entry entry : instanceAddresses.entrySet()) {
            content[i] = new RemoveInstancesDialog.Content((String)entry.getValue());
            ++i;
        }
        Arrays.sort(content, new Comparator<RemoveInstancesDialog.Content>(){

            @Override
            public int compare(RemoveInstancesDialog.Content o1, RemoveInstancesDialog.Content o2) {
                return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.label, (Object)o2.label);
            }
        });
        final Session session = graph.getSession();
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    boolean doIt;
                    RemoveInstancesDialog dialog = new RemoveInstancesDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Remove " + typeDescription + "?", String.valueOf(typeDescription) + " for '" + typeName + "' is still in use in " + instances.size() + " instances. Are you sure you want to remove it?", content);
                    int result = dialog.open();
                    boolean bl = doIt = result == 0;
                    if (!doIt) {
                        return;
                    }
                    session.asyncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            TechTypeTableRemover.this.justRemove(graph);
                        }
                    });
                }
            });
        } else {
            this.justRemove(graph);
        }
    }
}

