/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.table;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.district.imports.DistrictImportUtils;
import org.simantics.district.network.ui.techtype.table.TechTypeTableView;
import org.simantics.utils.ui.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportTechTypeCSVHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportTechTypeCSVHandler.class);
    @Inject
    EPartService partService;

    @Execute
    public void execute(@Named(value="activeShell") Shell s) {
        FileDialog dialog = new FileDialog(s);
        String path = dialog.open();
        try {
            if (path != null) {
                Path p = Paths.get(path, new String[0]);
                if (Files.exists(p, new LinkOption[0])) {
                    DistrictImportUtils.readCSVHeader((Path)p, (char)';', (boolean)true);
                    TechTypeTableView.table.setTechTypePath(path);
                } else {
                    LOGGER.warn("Path does not exist even though path != null: {}", (Object)p);
                }
            } else {
                LOGGER.error("Invalid file path given {}", (Object)path);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not read file {}", (Object)path, (Object)e);
            ExceptionUtils.logAndShowError((String)("Could not read file " + path + " : " + e.getMessage()), (Throwable)e);
        }
    }
}

