/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.participants;

import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.ToDoubleFunction;
import org.simantics.district.network.ui.adapters.DistrictNetworkEdgeElement;
import org.simantics.district.network.ui.adapters.DistrictNetworkVertexElement;
import org.simantics.district.network.ui.nodes.DistrictNetworkVertexNode;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;

public class DNPickSorter
implements PickRequest.PickSorter {
    public static ToDoubleFunction<Rectangle2D> centerDistSq(double x, double y) {
        return r -> {
            double dx = r.getCenterX() - x;
            double dy = r.getCenterY() - y;
            return dx * dx + dy * dy;
        };
    }

    public static ToDoubleFunction<Rectangle2D> centerDistSq(Rectangle2D r1) {
        return DNPickSorter.centerDistSq(r1.getCenterX(), r1.getCenterY());
    }

    public static Comparator<IElement> nearestVerticesFirst(boolean nearestLast, ToDoubleFunction<Rectangle2D> distanceFunction) {
        int sign = nearestLast ? 1 : -1;
        return (e1, e2) -> {
            DistrictNetworkVertexNode v1 = (DistrictNetworkVertexNode)e1.getHint(DistrictNetworkVertexElement.KEY_DN_VERTEX_NODE);
            DistrictNetworkVertexNode v2 = (DistrictNetworkVertexNode)e2.getHint(DistrictNetworkVertexElement.KEY_DN_VERTEX_NODE);
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 != null && v2 != null) {
                double dist2;
                double dist1 = distanceFunction.applyAsDouble(v1.getBounds());
                return dist1 < (dist2 = distanceFunction.applyAsDouble(v2.getBounds())) ? sign : (dist1 > dist2 ? -sign : 0);
            }
            return v1 != null && v2 == null ? sign : -sign;
        };
    }

    private static IG2DNode getNode(IElement element) {
        IG2DNode node = (IG2DNode)element.getHint(DistrictNetworkEdgeElement.KEY_DN_EDGE_NODE);
        if (node == null) {
            node = (IG2DNode)element.getHint(DistrictNetworkVertexElement.KEY_DN_VERTEX_NODE);
        }
        if (node == null && (node = (IG2DNode)element.getHint(ElementHints.KEY_SG_NODE)) instanceof SingleElementNode) {
            SingleElementNode snode = (SingleElementNode)node;
            node = (IG2DNode)snode.getNodes().iterator().next();
        }
        return node;
    }

    private static Comparator<IElement> zSorter() {
        return (e1, e2) -> {
            IG2DNode e1node = DNPickSorter.getNode(e1);
            IG2DNode e2node = DNPickSorter.getNode(e2);
            if (e1node.getZIndex() < e2node.getZIndex()) {
                return -1;
            }
            if (e1node.getZIndex() > e2node.getZIndex()) {
                return 1;
            }
            return 0;
        };
    }

    public void sort(List<IElement> elements) {
        Collections.sort(elements, DNPickSorter.zSorter());
    }

    public void sort(PickRequest req, List<IElement> elements) {
        Collections.sort(elements, DNPickSorter.zSorter());
        Collections.sort(elements, DNPickSorter.nearestVerticesFirst(true, DNPickSorter.centerDistSq(req.pickArea.getBounds2D())));
    }
}

