/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.simantics.NameLabelUtil;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.modifiers.EnumeratedValue;
import org.simantics.browsing.ui.common.modifiers.Enumeration;
import org.simantics.browsing.ui.graph.impl.GraphEnumerationModifier;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.ReadInterface;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.function.DefaultMappingsDialog;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.typicals.TypicalUtil;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.commands.CommandSessionImportEntry;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.simantics.ui.workbench.action.DefaultActions;
import org.simantics.utils.ui.SWTUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Functions {
    private static final Logger LOGGER = LoggerFactory.getLogger(Functions.class);
    private static final Function1<Resource, Double> ONE = new FunctionImpl1<Resource, Double>(){
        private final Double ONE = 1.0;

        public Double apply(Resource edge) {
            return this.ONE;
        }

        public String toString() {
            return "1";
        }
    };

    private Functions() {
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object defaultEdgeMappingModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Resource diagram = Functions.resolveElement(graph, context);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        return Functions.baseMappingModifier(graph, diagram, DN.EdgeDefaultMapping, DN.Mapping_EdgeMapping, context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object defaultVertexMappingModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Resource diagram = Functions.resolveElement(graph, context);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        return Functions.baseMappingModifier(graph, diagram, DN.VertexDefaultMapping, DN.Mapping_VertexMapping, context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object rightClickVertexMappingModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Resource diagram = Functions.resolveElement(graph, context);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        return Functions.baseMappingModifier(graph, diagram, DN.RightClickDefaultMapping, DN.Mapping_VertexMapping, context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object leftClickVertexMappingModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Resource diagram = Functions.resolveElement(graph, context);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        return Functions.baseMappingModifier(graph, diagram, DN.LeftClickDefaultMapping, DN.Mapping_VertexMapping, context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object mappingModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Resource element = Functions.resolveElement(graph, context);
        Resource mappingType = Functions.resolveMappingType(graph, element);
        return Functions.baseMappingModifier(graph, element, DistrictNetworkResource.getInstance((ReadGraph)graph).HasMapping, mappingType, context);
    }

    public static Map<String, Resource> getVertexMappings(ReadGraph graph, Resource indexRoot) throws DatabaseException {
        Map<String, Resource> second = Functions.getNetworkMappingsByType(graph, indexRoot, DistrictNetworkResource.getInstance((ReadGraph)graph).Mapping_VertexMapping);
        return second;
    }

    public static Map<String, Resource> getEdgeMappings(ReadGraph graph, Resource indexRoot) throws DatabaseException {
        Map<String, Resource> second = Functions.getNetworkMappingsByType(graph, indexRoot, DistrictNetworkResource.getInstance((ReadGraph)graph).Mapping_EdgeMapping);
        return second;
    }

    public static Map<String, Resource> getCRSs(ReadGraph graph, Resource resource) throws DatabaseException {
        Map<String, Resource> result = Functions.getNetworkMappingsByType(graph, (Resource)graph.sync((ReadInterface)new IndexRoot(resource)), DistrictNetworkResource.getInstance((ReadGraph)graph).SpatialRefSystem);
        return result;
    }

    public static Map<String, Resource> getNetworkMappingsByType(ReadGraph graph, Resource indexRoot, Resource mappingType) throws DatabaseException {
        List mappings = QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)indexRoot, (Resource)mappingType);
        HashMap<String, Resource> result = new HashMap<String, Resource>(mappings.size());
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        mappings.forEach(mapping -> {
            try {
                String name = (String)graph.getRelatedValue2(mapping, layer0.HasName);
                Resource existing = result.put(name, (Resource)mapping);
                if (existing != null) {
                    LOGGER.warn("Duplicate mapping name! {} {} and existing is {}", new Object[]{name, mapping, existing});
                }
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        });
        return result;
    }

    private static Object baseMappingModifier(ReadGraph graph, Resource element, Resource property, Resource mappingType, Variable context) throws DatabaseException {
        Resource indexRoot = (Resource)graph.sync((ReadInterface)new IndexRoot(element));
        List mappings = QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)indexRoot, (Resource)mappingType);
        Enumeration enums = Enumeration.make(mappings.stream().map(m -> Functions.createEnumeratedValue(graph, m)).collect(Collectors.toList()));
        Resource currentMapping = graph.getSingleObject(element, property);
        return new HasMappingEnumerationModifier(Simantics.getSession(), element, property, (Enumeration<Resource>)enums, currentMapping);
    }

    private static Resource resolveMappingType(ReadGraph graph, Resource element) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(element, DN.Edge)) {
            return DN.Mapping_EdgeMapping;
        }
        if (graph.isInstanceOf(element, DN.Vertex)) {
            return DN.Mapping_VertexMapping;
        }
        throw new IllegalStateException("No mapping type found for element " + element + " : " + graph.getPossibleURI(element));
    }

    private static Resource resolveElement(ReadGraph graph, Variable variable) throws DatabaseException {
        Variables.Role role = variable.getPossibleRole(graph);
        if (role.equals((Object)Variables.Role.PROPERTY)) {
            return Functions.resolveElement(graph, variable.getParent(graph));
        }
        return variable.getRepresents(graph);
    }

    private static EnumeratedValue<Resource> createEnumeratedValue(ReadGraph graph, Resource resource) {
        try {
            String label = NameLabelUtil.modalName((ReadGraph)graph, (Resource)resource);
            return new EnumeratedValue(label, (Object)resource);
        }
        catch (DatabaseException e) {
            throw new RuntimeDatabaseException((Throwable)e);
        }
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object enumerationValues(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        Variable cfr_ignored_0 = (Variable)context;
        return Collections.emptyList();
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object convertToValue(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String label = (String)graph.getPossibleRelatedValue2(resource, L0.HasLabel, (Binding)Bindings.STRING);
        if (label == null) {
            label = (String)graph.getRelatedValue(resource, L0.HasName, (Binding)Bindings.STRING);
        }
        return label;
    }

    @SCLValue(type="Resource -> String -> Resource -> Resource")
    public static Resource compositeInstantiator(Resource compositeType, String defaultName, Resource target) throws DatabaseException {
        return (Resource)TypicalUtil.syncExec(procedure -> {
            if (!SWTUtils.asyncExec((Display)PlatformUI.getWorkbench().getDisplay(), () -> {
                try {
                    Functions.queryInitialValuesAndCreateComposite(compositeType, target, defaultName, (Procedure<Resource>)procedure);
                }
                catch (Throwable t) {
                    procedure.exception(t);
                }
            })) {
                procedure.execute(null);
            }
        });
    }

    public static void queryInitialValuesAndCreateComposite(Resource compositeType, Resource target, String defaultName, final Procedure<Resource> procedure) {
        DefaultMappingsDialog dialog = new DefaultMappingsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), target);
        if (dialog.open() != 0) {
            procedure.execute(null);
            return;
        }
        Simantics.getSession().asyncRequest(graph -> DistrictNetworkUtil.createNetworkDiagram((WriteGraph)graph, (Resource)target, (Resource)compositeType, (String)defaultName, (Resource)dialog.getDefaultEdgeMapping(), (Resource)dialog.getDefaultVertexMapping(), (Resource)dialog.getRightClickVertexMapping(), (Resource)dialog.getLeftClickVertexMapping(), (Resource)dialog.getCRS()), (Procedure)new Procedure<Resource>(){

            public void execute(Resource composite) {
                DefaultActions.asyncPerformDefaultAction((Session)Simantics.getSession(), (Object)composite, (boolean)false, (boolean)false, (boolean)true);
                procedure.execute((Object)composite);
            }

            public void exception(Throwable t) {
                LOGGER.error("Failed to create composite, see exception for details.", t);
                procedure.exception(t);
            }
        });
    }

    public static Collection<Resource> getDistrictDiagrams(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection indexRoots = (Collection)graph.sync((ReadInterface)new ObjectsWithType(Simantics.getProjectResource(), L0.ConsistsOf, L0.IndexRoot));
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        HashSet<Resource> results = new HashSet<Resource>();
        for (Resource indexRoot : indexRoots) {
            List diagrams = QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)indexRoot, (Resource)DN.Diagram);
            results.addAll(diagrams);
        }
        return results;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Function1<Resource, Double> hasDiameterValue(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return Functions.directPropertyValueFunction(DistrictNetworkResource.getInstance((ReadGraph)graph).Edge_HasDiameter, 0.0);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Function1<Resource, Double> hasNominalMassFlowValue(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return Functions.directPropertyValueFunction(DistrictNetworkResource.getInstance((ReadGraph)graph).Edge_HasNominalMassFlow, 0.0);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Function1<Resource, Double> hasNominalSupplyPressure(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return Functions.directPropertyValueFunction(DistrictNetworkResource.getInstance((ReadGraph)graph).Vertex_HasSupplyPressure, 0.0);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Function1<Resource, Double> hasElevation(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return Functions.directPropertyValueFunction(DistrictNetworkResource.getInstance((ReadGraph)graph).Vertex_HasElevation, 0.0);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Function1<Resource, Double> constantOne(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return ONE;
    }

    private static Function1<Resource, Double> directPropertyValueFunction(final Resource property, double defaultValue) throws DatabaseException {
        final Double def = defaultValue;
        return new FunctionImpl1<Resource, Double>(){

            public Double apply(Resource edge) {
                ReadGraph graph = (ReadGraph)SCLContext.getCurrent().get((Object)"graph");
                try {
                    Double d = (Double)graph.getPossibleRelatedValue(edge, property, (Binding)Bindings.DOUBLE);
                    return d != null ? d : def;
                }
                catch (DatabaseException e) {
                    LOGGER.error("Failed to evaluate property value", (Throwable)e);
                    return def;
                }
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object hueValidator(ReadGraph graph, Resource r, Variable context) throws DatabaseException {
        return new RangeValidator(0.0, 360.0);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object saturationValidator(ReadGraph graph, Resource r, Variable context) throws DatabaseException {
        return new RangeValidator(0.0, 100.0);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object brightnessValidator(ReadGraph graph, Resource r, Variable context) throws DatabaseException {
        Resource sclmain;
        String importEntry = null;
        Resource root = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)context);
        if (root != null && (sclmain = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)root, (String)"SCLMain")) != null) {
            importEntry = graph.getPossibleURI(sclmain);
        }
        SCLContext ctx = SCLContext.getCurrent();
        Object oldGraph = ctx.put((Object)"graph", (Object)graph);
        try {
            BrightnessExpressionValidator brightnessExpressionValidator = new BrightnessExpressionValidator(importEntry != null ? Arrays.asList(importEntry) : Collections.emptyList());
            return brightnessExpressionValidator;
        }
        finally {
            ctx.put((Object)"graph", oldGraph);
        }
    }

    private static class BrightnessExpressionValidator
    implements Function1<String, String> {
        private CommandSession session = new CommandSession(SCLOsgi.MODULE_REPOSITORY, SCLReportingHandler.DEFAULT);

        public BrightnessExpressionValidator(List<String> importEntries) {
            this.session.setImportEntries(this.imports(importEntries));
        }

        private ArrayList<CommandSessionImportEntry> imports(List<String> entries) {
            ArrayList<CommandSessionImportEntry> result = new ArrayList<CommandSessionImportEntry>();
            entries.stream().map(CommandSessionImportEntry::new).forEach(result::add);
            if (entries.isEmpty()) {
                result.add(new CommandSessionImportEntry("Simantics/District/SCLMain"));
            }
            return result;
        }

        public String apply(String s) {
            if (!(s = s.trim()).startsWith("=")) {
                return "Expression expected, must start with '='";
            }
            CompilationError[] errors = this.session.validate(s.substring(1));
            if (errors.length == 0) {
                return null;
            }
            return errors[0].description;
        }
    }

    private static class HasMappingEnumerationModifier
    extends GraphEnumerationModifier {
        public HasMappingEnumerationModifier(Session session, Resource subject, Resource relation, Enumeration<Resource> enumeration, Resource value) {
            super(session, subject, relation, enumeration, value);
        }
    }

    private static class RangeValidator
    implements Function1<String, String> {
        private double min;
        private double max;

        public RangeValidator(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public String apply(String s) {
            try {
                double d = Double.parseDouble(s);
                if (d < this.min) {
                    return "Value must be greater than or equal to " + this.min;
                }
                if (d > this.max) {
                    return "Value must be less than or equal to " + this.max;
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                return "Specified value is not a number";
            }
        }
    }
}

