/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.function;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.function.Functions;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMappingsDialog
extends SelectionStatusDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMappingsDialog.class);
    private Combo vertexMappingCombo;
    private Combo rightClickMappingCombo;
    private Combo leftClickMappingCombo;
    private Combo edgeMappingCombo;
    private Composite composite;
    private Resource configuration;
    private Map<String, Resource> vertexMappings = new HashMap<String, Resource>();
    private Map<String, Resource> edgeMappings = new HashMap<String, Resource>();
    private Map<String, Resource> composites = new HashMap<String, Resource>();
    private Map<String, Resource> crss = new HashMap<String, Resource>();
    private Resource defaultVertexMapping;
    private Resource defaultEdgeMapping;
    private Resource rightClickVertexMapping;
    private Resource leftClickVertexMapping;

    protected DefaultMappingsDialog(Shell parentShell, Resource configuration) {
        super(parentShell);
        this.configuration = configuration;
        this.setTitle("Select mappings for new DN diagram");
    }

    public Resource getDefaultVertexMapping() {
        return this.defaultVertexMapping;
    }

    public Resource getRightClickVertexMapping() {
        return this.rightClickVertexMapping;
    }

    public Resource getLeftClickVertexMapping() {
        return this.leftClickVertexMapping;
    }

    public Resource getDefaultEdgeMapping() {
        return this.defaultEdgeMapping;
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = (Composite)super.createDialogArea(parent);
        this.createMappingsGroup(this.composite);
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Resource indexRoot = (Resource)graph.sync((ReadInterface)new IndexRoot(DefaultMappingsDialog.this.configuration));
                DefaultMappingsDialog.this.vertexMappings = Functions.getVertexMappings(graph, indexRoot);
                DefaultMappingsDialog.this.edgeMappings = Functions.getEdgeMappings(graph, indexRoot);
                DefaultMappingsDialog.this.composites = DefaultMappingsDialog.this.getComposites(graph, DefaultMappingsDialog.this.configuration);
                DefaultMappingsDialog.this.crss = Functions.getCRSs(graph, DefaultMappingsDialog.this.configuration);
                DefaultMappingsDialog.this.composite.getDisplay().asyncExec(() -> {
                    DefaultMappingsDialog.this.vertexMappingCombo.setItems(DefaultMappingsDialog.this.vertexMappings.keySet().toArray(new String[DefaultMappingsDialog.this.vertexMappings.size()]));
                    DefaultMappingsDialog.this.rightClickMappingCombo.setItems(DefaultMappingsDialog.this.vertexMappings.keySet().toArray(new String[DefaultMappingsDialog.this.vertexMappings.size()]));
                    DefaultMappingsDialog.this.leftClickMappingCombo.setItems(DefaultMappingsDialog.this.vertexMappings.keySet().toArray(new String[DefaultMappingsDialog.this.vertexMappings.size()]));
                    DefaultMappingsDialog.this.edgeMappingCombo.setItems(DefaultMappingsDialog.this.edgeMappings.keySet().toArray(new String[DefaultMappingsDialog.this.edgeMappings.size()]));
                    DefaultMappingsDialog.this.vertexMappingCombo.select(0);
                    DefaultMappingsDialog.this.rightClickMappingCombo.select(0);
                    DefaultMappingsDialog.this.leftClickMappingCombo.select(0);
                    DefaultMappingsDialog.this.edgeMappingCombo.select(0);
                });
            }
        });
        return this.composite;
    }

    protected Map<String, Resource> getComposites(ReadGraph graph, Resource element) throws DatabaseException {
        List<Resource> nonDistrictComposites = this.composites.values().stream().filter(comp -> {
            try {
                return !graph.isInstanceOf(comp, DistrictNetworkResource.getInstance((ReadGraph)readGraph).Composite);
            }
            catch (ServiceException serviceException) {
                LOGGER.error("Could not check if composite " + comp + " is instanceOf DistrictNetwork.composite");
                return false;
            }
        }).collect(Collectors.toList());
        HashMap<String, Resource> result = new HashMap<String, Resource>(nonDistrictComposites.size());
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        nonDistrictComposites.forEach(mapping -> {
            try {
                String name = (String)graph.getRelatedValue2(mapping, layer0.HasName);
                result.put(name, (Resource)mapping);
            }
            catch (DatabaseException e) {
                LOGGER.error("Could not read name of " + mapping, (Throwable)e);
            }
        });
        return result;
    }

    private void createMappingsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setText("Default mappings");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        group.setLayout((Layout)new GridLayout(1, false));
        Composite cmposite = new Composite((Composite)group, 0);
        cmposite.setLayoutData((Object)new GridData(4, 128, true, false));
        cmposite.setLayout((Layout)new GridLayout(2, false));
        Label vertexMappingLabel = new Label(cmposite, 0);
        vertexMappingLabel.setText("Default vertex mapping");
        this.vertexMappingCombo = new Combo(cmposite, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.vertexMappingCombo);
        Label rightClickMappingLabel = new Label(cmposite, 0);
        rightClickMappingLabel.setText("Default right click mapping");
        this.rightClickMappingCombo = new Combo(cmposite, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.vertexMappingCombo);
        Label leftClickMappingLabel = new Label(cmposite, 0);
        leftClickMappingLabel.setText("Default left click mapping");
        this.leftClickMappingCombo = new Combo(cmposite, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.vertexMappingCombo);
        Label edgeMappingLabel = new Label(cmposite, 0);
        edgeMappingLabel.setText("Default edge mapping");
        this.edgeMappingCombo = new Combo(cmposite, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.edgeMappingCombo);
    }

    private void createExistingCompositeGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setText("Mapped composite");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        group.setLayout((Layout)new GridLayout(1, false));
        Composite cmposite = new Composite((Composite)group, 0);
        cmposite.setLayoutData((Object)new GridData(4, 128, true, false));
        cmposite.setLayout((Layout)new GridLayout(2, false));
        Label compositeMappingLabel = new Label(cmposite, 0);
        compositeMappingLabel.setText("Select composite");
    }

    protected void recalculateMappapleComponents() {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                DefaultMappingsDialog.this.composite.getDisplay().asyncExec(() -> {});
            }
        });
    }

    private void createCRSSettingsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setText("CRS settings");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        group.setLayout((Layout)new GridLayout(1, false));
        Composite cmposite = new Composite((Composite)group, 0);
        cmposite.setLayoutData((Object)new GridData(4, 128, true, false));
        cmposite.setLayout((Layout)new GridLayout(2, false));
        Label vertexMappingLabel = new Label(cmposite, 0);
        vertexMappingLabel.setText("Default CRS");
    }

    protected void computeResult() {
        this.defaultVertexMapping = this.vertexMappings.get(this.vertexMappingCombo.getItem(this.vertexMappingCombo.getSelectionIndex()));
        this.defaultEdgeMapping = this.edgeMappings.get(this.edgeMappingCombo.getItem(this.edgeMappingCombo.getSelectionIndex()));
        this.rightClickVertexMapping = this.vertexMappings.get(this.rightClickMappingCombo.getItem(this.rightClickMappingCombo.getSelectionIndex()));
        this.leftClickVertexMapping = this.vertexMappings.get(this.leftClickMappingCombo.getItem(this.leftClickMappingCombo.getSelectionIndex()));
    }

    public Resource getCRS() {
        return this.crss.get("EPSG_4326");
    }
}

