/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.contributions;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.contributions.CopyDistrictVertexHandler;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ISelectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasteDistrictVertexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PasteDistrictVertexHandler.class);

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ISelection selection) {
        final List elements = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (elements.size() < 1) {
            return false;
        }
        try {
            return (Boolean)Simantics.getSession().syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                    for (Resource selection : elements) {
                        if (graph.isInstanceOf(selection, DN.Element)) continue;
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Could not evaluate if mapping can be changed for selection {}", (Object)elements, (Object)e);
            return false;
        }
    }

    private static Resource doCopy(WriteGraph graph, Resource diagram, Resource target, Resource source) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        double[] location = (double[])graph.getRelatedValue(target, DIA.HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
        double elevation = (Double)graph.getRelatedValue(target, DN.Vertex_HasElevation, (Binding)Bindings.DOUBLE);
        Resource vertex = DistrictNetworkUtil.createVertex((WriteGraph)graph, (Resource)diagram, (double[])location, (double)elevation);
        PasteDistrictVertexHandler.copySourceToTarget(graph, source, vertex);
        return vertex;
    }

    private static void copySourceToTarget(WriteGraph graph, Resource source, Resource target) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        graph.deny(target, DN.HasMapping);
        Collection statements = graph.getStatements(source, L0.HasProperty);
        Collection assertedStatements = graph.getAssertedStatements(source, L0.HasProperty);
        statements.removeAll(assertedStatements);
        for (Statement stm : statements) {
            if (graph.hasStatement(target, stm.getPredicate())) continue;
            graph.claim(target, stm.getPredicate(), stm.getObject());
        }
    }

    private static void copyVertexInverses(WriteGraph graph, Resource sourceElement, Resource targetElement) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Collection sourceStartVertex_inverse = graph.getObjects(sourceElement, DN.HasStartVertex_Inverse);
        Collection sourceEndVertex_inverse = graph.getObjects(sourceElement, DN.HasEndVertex_Inverse);
        Collection targetStartVertex_inverse = graph.getObjects(targetElement, DN.HasStartVertex_Inverse);
        Collection targetEndVertex_inverse = graph.getObjects(targetElement, DN.HasEndVertex_Inverse);
        graph.deny(sourceElement, DN.HasStartVertex_Inverse);
        graph.deny(sourceElement, DN.HasEndVertex_Inverse);
        graph.deny(targetElement, DN.HasStartVertex_Inverse);
        graph.deny(targetElement, DN.HasEndVertex_Inverse);
        for (Resource startVertexInverse : sourceStartVertex_inverse) {
            graph.claim(targetElement, DN.HasStartVertex_Inverse, startVertexInverse);
        }
        for (Resource targetVertexInverse : targetStartVertex_inverse) {
            graph.claim(sourceElement, DN.HasStartVertex_Inverse, targetVertexInverse);
        }
        for (Resource endVertexInverse : sourceEndVertex_inverse) {
            graph.claim(targetElement, DN.HasEndVertex_Inverse, endVertexInverse);
        }
        for (Resource targetVertexInverse : targetEndVertex_inverse) {
            graph.claim(sourceElement, DN.HasEndVertex_Inverse, targetVertexInverse);
        }
    }

    private static void deleteExistingTarget(WriteGraph graph, Resource target) throws DatabaseException {
        RemoverUtil.remove((WriteGraph)graph, (Resource)target);
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") Object selection) {
        List elements = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        List<Resource> copiedElements = CopyDistrictVertexHandler.elements;
        final boolean cut = CopyDistrictVertexHandler.cut;
        final Resource targetElement = (Resource)elements.get(0);
        final Resource sourceElement = copiedElements.get(0);
        try {
            final HashMap sourceCopyAttributes = new HashMap();
            final HashMap targetCopyAttributes = new HashMap();
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                    Resource sourceMappedElement = graph.getPossibleObject(sourceElement, DN.MappedComponent);
                    sourceCopyAttributes.putAll(PasteDistrictVertexHandler.copyAttributes(graph, sourceElement, sourceMappedElement));
                    Resource targetMappedElement = graph.getPossibleObject(targetElement, DN.MappedComponent);
                    targetCopyAttributes.putAll(PasteDistrictVertexHandler.copyAttributes(graph, targetElement, targetMappedElement));
                    if (sourceMappedElement != null && cut) {
                        RemoverUtil.remove((WriteGraph)graph, (Resource)sourceMappedElement);
                    }
                    if (targetMappedElement != null) {
                        RemoverUtil.remove((WriteGraph)graph, (Resource)targetMappedElement);
                    }
                }
            });
            ThreadUtils.getNonBlockingWorkExecutor().schedule(() -> {
                try {
                    Simantics.getSession().syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            Resource diagram = graph.getSingleObject(sourceElement, L0.PartOf);
                            Resource newTarget = PasteDistrictVertexHandler.doCopy(graph, diagram, targetElement, sourceElement);
                            if (cut) {
                                Resource newSource = PasteDistrictVertexHandler.doCopy(graph, diagram, sourceElement, targetElement);
                                for (Map.Entry attrValue : targetCopyAttributes.entrySet()) {
                                    graph.claimLiteral(newSource, (Resource)attrValue.getKey(), attrValue.getValue());
                                }
                                PasteDistrictVertexHandler.copyVertexInverses(graph, sourceElement, newSource);
                                PasteDistrictVertexHandler.deleteExistingTarget(graph, sourceElement);
                            }
                            for (Map.Entry attrValue : sourceCopyAttributes.entrySet()) {
                                graph.claimLiteral(newTarget, (Resource)attrValue.getKey(), attrValue.getValue());
                            }
                            PasteDistrictVertexHandler.copyVertexInverses(graph, targetElement, newTarget);
                            PasteDistrictVertexHandler.deleteExistingTarget(graph, targetElement);
                        }
                    });
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            }, 500L, TimeUnit.MILLISECONDS);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    private static Map<Resource, Object> copyAttributes(WriteGraph graph, Resource sourceElement, Resource mappedElement) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Resource mapping = graph.getSingleObject(sourceElement, DN.HasMapping);
        Collection statements = graph.getStatements(mapping, L0.HasProperty);
        Collection mappingAttributeStatements = statements.stream().filter(stm -> {
            try {
                Resource predicate = stm.getPredicate();
                Resource hasDomain = graph.getPossibleObject(predicate, layer0.HasDomain);
                if (hasDomain != null && hasDomain.equals(districtNetworkResource.Mapping_VertexMapping)) {
                    Resource vertexAttribute = PasteDistrictVertexHandler.attributeMappingToVertexAttribute((ReadGraph)graph, DN, predicate);
                    return vertexAttribute != null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }).collect(Collectors.toList());
        Resource component = graph.getPossibleObject(mappedElement, ModelingResources.getInstance((ReadGraph)graph).ElementToComponent);
        Variable variable = Variables.getVariable((ReadGraph)graph, (Resource)component);
        HashMap<Resource, Object> predValues = new HashMap<Resource, Object>();
        for (Statement stm2 : mappingAttributeStatements) {
            String propertyName = (String)graph.getPossibleValue(stm2.getObject());
            if (propertyName != null) {
                Object propertyValue = variable.getPossiblePropertyValue((ReadGraph)graph, propertyName);
                if (propertyValue != null) {
                    predValues.put(PasteDistrictVertexHandler.attributeMappingToVertexAttribute((ReadGraph)graph, DN, stm2.getPredicate()), propertyValue);
                    continue;
                }
                System.err.println("no property value for " + variable.getURI((ReadGraph)graph) + " and property " + propertyName);
                continue;
            }
            System.err.println("stm.getObject() is not string " + stm2.getObject());
        }
        return predValues;
    }

    private static Resource attributeMappingToVertexAttribute(ReadGraph graph, DistrictNetworkResource DN, Resource attribute) throws DatabaseException {
        Resource attr = null;
        if (attribute.equals(DN.Mapping_VertexMapping_ElevationAttribute)) {
            attr = null;
        } else if (attribute.equals(DN.Mapping_VertexMapping_AddressAttribute)) {
            attr = DN.Vertex_HasAddress;
        } else if (attribute.equals(DN.Mapping_VertexMapping_DeltaPressureAttribute)) {
            attr = DN.Vertex_HasDeltaPressure;
        } else if (attribute.equals(DN.Mapping_VertexMapping_DeltaTemperatureAttribute)) {
            attr = DN.Vertex_HasDeltaTemperature;
        } else if (attribute.equals(DN.Mapping_VertexMapping_dpAttribute)) {
            attr = DN.Vertex_HasDeltaPressure;
        } else if (attribute.equals(DN.Mapping_VertexMapping_dtAttribute)) {
            attr = DN.Vertex_HasDeltaTemperature;
        } else if (attribute.equals(DN.Mapping_VertexMapping_FlowAreaAttribute)) {
            attr = DN.Vertex_HasFlowArea;
        } else if (attribute.equals(DN.Mapping_VertexMapping_HeatLoadDsAttribute)) {
            attr = DN.Vertex_HasHeatLoadDs;
        } else if (attribute.equals(DN.Mapping_VertexMapping_HeatPowerAttribute)) {
            attr = DN.Vertex_HasHeatPower;
        } else if (attribute.equals(DN.Mapping_VertexMapping_MassFlowAttribute)) {
            attr = DN.Vertex_HasMassFlow;
        } else if (attribute.equals(DN.Mapping_VertexMapping_MaximumHeadMAttribute)) {
            attr = DN.Vertex_HasMaximumHeadM;
        } else if (attribute.equals(DN.Mapping_VertexMapping_NominalFlowAttribute)) {
            attr = DN.Vertex_HasNominalFlow;
        } else if (attribute.equals(DN.Mapping_VertexMapping_NominalHeadBAttribute)) {
            attr = DN.Vertex_HasNominalHeadB_Inverse;
        } else if (attribute.equals(DN.Mapping_VertexMapping_NominalHeadMAttribute)) {
            attr = DN.Vertex_HasNominalHeadM;
        } else if (attribute.equals(DN.Mapping_VertexMapping_NominalMassFlowAttribute)) {
            attr = DN.Vertex_HasNominalFlow;
        } else if (attribute.equals(DN.Mapping_VertexMapping_NominalPressureLossAttribute)) {
            attr = DN.Vertex_HasNominalPressureLoss;
        } else if (attribute.equals(DN.Mapping_VertexMapping_ReturnPressureAttribute)) {
            attr = DN.Vertex_HasReturnPressure;
        } else if (attribute.equals(DN.Mapping_VertexMapping_ReturnTemperatureAttribute)) {
            attr = DN.Vertex_HasReturnTemperature;
        } else if (attribute.equals(DN.Mapping_VertexMapping_SupplyPressureAttribute)) {
            attr = DN.Vertex_HasSupplyPressure;
        } else if (attribute.equals(DN.Mapping_VertexMapping_SupplyTemperatureAttribute)) {
            attr = DN.Vertex_HasSupplyTemperature;
        } else if (attribute.equals(DN.Mapping_VertexMapping_ValvePositionAttribute)) {
            attr = DN.Vertex_HasValvePosition;
        } else if (attribute.equals(DN.Mapping_VertexMapping_VelocityAttribute)) {
            attr = DN.Vertex_HasVelocity;
        } else if (attribute.equals(DN.Mapping_VertexMapping_VolFlowAttribute)) {
            attr = DN.Vertex_HasVolFlow;
        } else if (attribute.equals(DN.Mapping_VertexMapping_PumpInReturnLineAttribute)) {
            attr = DN.Vertex_HasPumpInReturnLine;
        } else if (attribute.equals(DN.Mapping_VertexMapping_HeadPumpMaximumAttribute)) {
            attr = DN.Vertex_HasHeadPumpMaximum;
        } else if (attribute.equals(DN.Mapping_VertexMapping_HeadPumpNominalAttribute)) {
            attr = DN.Vertex_HasHeadPumpNominal;
        } else if (attribute.equals(DN.Mapping_VertexMapping_FrequencyConverterControlledAttribute)) {
            attr = DN.Vertex_HasFrequencyConverterControlled;
        } else if (attribute.equals(DN.Mapping_VertexMapping_InternalValveMeasurementAttribute)) {
            attr = DN.Vertex_HasInternalValveMeasurement;
        } else if (attribute.equals(DN.Mapping_VertexMapping_PumpMassFlowNominalAttribute)) {
            attr = DN.Vertex_HasPumpMassFlowNominal;
        } else if (attribute.equals(DN.Mapping_VertexMapping_PumpMeMaxAttribute)) {
            attr = DN.Vertex_HasPumpMeMax;
        } else if (attribute.equals(DN.Mapping_VertexMapping_PumpMeMinAttribute)) {
            attr = DN.Vertex_HasPumpMeMin;
        } else if (attribute.equals(DN.Mapping_VertexMapping_PumpSpeedMaxAttribute)) {
            attr = DN.Vertex_HasPumpSpeedMax;
        } else if (attribute.equals(DN.Mapping_VertexMapping_PumpSpeedMinAttribute)) {
            attr = DN.Vertex_HasPumpSpeedMin;
        } else if (attribute.equals(DN.Mapping_VertexMapping_ValveReturnLineAttribute)) {
            attr = DN.Vertex_HasValveReturnLine;
        } else if (attribute.equals(DN.Mapping_VertexMapping_ValveMeMaxAttribute)) {
            attr = DN.Vertex_HasValveMeMax;
        } else if (attribute.equals(DN.Mapping_VertexMapping_ValveMeMinAttribute)) {
            attr = DN.Vertex_HasValveMeMin;
        } else if (attribute.equals(DN.Mapping_VertexMapping_ValveMinPositionAttribute)) {
            attr = DN.Vertex_HasValveMinPosition;
        } else if (attribute.equals(DN.Mapping_VertexMapping_ValveOutletModeAttribute)) {
            attr = DN.Vertex_HasValveOutletMode;
        } else if (attribute.equals(DN.Mapping_VertexMapping_ValvePressLossNominalAttribute)) {
            attr = DN.Vertex_HasValvePressLossNominal;
        } else if (attribute.equals(DN.Mapping_VertexMapping_OpeningTimeAttribute)) {
            attr = DN.Vertex_HasOpeningTime;
        } else if (attribute.equals(DN.Mapping_VertexMapping_XAttribute)) {
            attr = null;
        } else if (attribute.equals(DN.Mapping_VertexMapping_YAttribute)) {
            attr = null;
        }
        return attr;
    }
}

