/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui;

import java.util.HashMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.layer.GraphLayer;
import org.simantics.diagram.synchronization.graph.layer.GraphLayerUtil;
import org.simantics.diagram.synchronization.graph.layer.IGraphLayerUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.layer0.Layer0;

public class DNGraphLayerUtil
implements IGraphLayerUtil {
    public DNGraphLayerUtil(Resource layer) {
    }

    public GraphLayer loadLayer(ReadGraph graph, Resource layer) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        String name = (String)graph.getRelatedValue(layer, L0.HasName);
        Resource visible = graph.getSingleObject(layer, DIA.HasVisibleTag);
        Resource focusable = graph.getSingleObject(layer, DIA.HasFocusableTag);
        HashMap<String, Resource> properties = new HashMap<String, Resource>();
        properties.put("PROP_FOCUSABLE", focusable);
        properties.put("PROP_VISIBLE", visible);
        return new GraphLayer(name, layer, properties);
    }

    public GraphLayer createLayer(WriteGraph graph, String layerName, boolean active) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Resource layer = graph.newResource();
        graph.claim(layer, L0.InstanceOf, null, DN.Layer);
        Resource visibleTag = GraphLayerUtil.newTag((WriteGraph)graph, (Layer0)L0, (Resource)DIA.IsVisible);
        Resource focusableTag = GraphLayerUtil.newTag((WriteGraph)graph, (Layer0)L0, (Resource)DIA.IsFocusable);
        graph.claim(layer, DIA.HasVisibleTag, visibleTag);
        graph.claim(layer, DIA.HasFocusableTag, focusableTag);
        Resource name = graph.newResource();
        graph.claim(name, L0.InstanceOf, null, L0.String);
        graph.claimValue(name, (Object)layerName);
        graph.claim(layer, L0.HasName, name);
        graph.claim(visibleTag, L0.HasName, name);
        graph.claim(focusableTag, L0.HasName, name);
        graph.claim(layer, DN.HasSpatialRefSystem, DN.EPSG_4326);
        GraphLayerUtil.setLayerActive((WriteGraph)graph, (DiagramResource)DIA, (Resource)layer, (boolean)active);
        HashMap<String, Resource> properties = new HashMap<String, Resource>();
        properties.put("PROP_FOCUSABLE", focusableTag);
        properties.put("PROP_VISIBLE", visibleTag);
        return new GraphLayer(layerName, layer, properties);
    }
}

