/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.cef;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.simantics.district.network.cef.Activator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistrictClientHtmlServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistrictClientHtmlServer.class);
    private HttpServer server = HttpServer.create(new InetSocketAddress(6999), 0);

    public DistrictClientHtmlServer() throws IOException, URISyntaxException {
        this.server.createContext("/", new AssetHandler(Activator.getClientBuildFolder(), false, true));
    }

    public void start() {
        this.server.start();
    }

    public InetSocketAddress getAddress() {
        return this.server.getAddress();
    }

    public void stop() {
        this.server.stop(1);
    }

    private static class AssetHandler
    implements HttpHandler {
        private static Map<String, Asset> data = new HashMap<String, Asset>();
        private final boolean cache;
        private final boolean gzip;
        private final Path root;

        public AssetHandler(Path root, boolean caching, boolean gzip) throws IOException {
            this.cache = caching;
            this.root = root;
            this.gzip = gzip;
            this.listFiles(root);
        }

        private void listFiles(Path path) throws IOException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                for (Path entry : stream) {
                    if (Files.isDirectory(entry, new LinkOption[0])) {
                        this.listFiles(entry);
                        continue;
                    }
                    Throwable throwable2 = null;
                    Object var8_11 = null;
                    try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(entry, new OpenOption[0]));){
                        data.put(this.root.relativize(entry).toString().replace("\\", "/"), AssetHandler.readResource(is, this.gzip));
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }

        private static Asset readResource(InputStream in, boolean gzip) throws IOException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedOutputStream gout = new BufferedOutputStream(gzip ? new GZIPOutputStream(bout) : new DataOutputStream(bout));){
                int r;
                byte[] tmp = new byte[4096];
                while ((r = in.read(tmp)) >= 0) {
                    ((OutputStream)gout).write(tmp, 0, r);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return new Asset(bout.toByteArray());
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            String path = httpExchange.getRequestURI().getPath();
            try {
                path = path.substring(1);
                path = path.replaceAll("//", "/");
                if (path.length() == 0) {
                    path = "index.html";
                }
                Asset res = data.get(path);
                if (this.gzip) {
                    httpExchange.getResponseHeaders().set("Content-Encoding", "gzip");
                }
                if (path.endsWith(".js")) {
                    httpExchange.getResponseHeaders().set("Content-Type", "text/javascript");
                } else if (path.endsWith(".html")) {
                    httpExchange.getResponseHeaders().set("Content-Type", "text/html");
                } else if (path.endsWith(".css")) {
                    httpExchange.getResponseHeaders().set("Content-Type", "text/css");
                } else if (path.endsWith(".json")) {
                    httpExchange.getResponseHeaders().set("Content-Type", "application/json");
                } else if (path.endsWith(".svg")) {
                    httpExchange.getResponseHeaders().set("Content-Type", "image/svg+xml");
                }
                if (httpExchange.getRequestMethod().equals("HEAD")) {
                    httpExchange.getResponseHeaders().set("Content-Length", "" + res.data.length);
                    httpExchange.sendResponseHeaders(200, -1L);
                    return;
                }
                httpExchange.sendResponseHeaders(200, res.data.length);
                httpExchange.getResponseBody().write(res.data);
                httpExchange.getResponseBody().close();
            }
            catch (NullPointerException t) {
                System.err.println("Error retrieving: " + path);
                t.printStackTrace();
                httpExchange.sendResponseHeaders(404, 0L);
                httpExchange.getResponseBody().close();
            }
            catch (Throwable t) {
                System.err.println("Error retrieving: " + path);
                t.printStackTrace();
            }
        }

        private static class Asset {
            public final byte[] data;

            public Asset(byte[] data) {
                this.data = data;
            }
        }
    }
}

