/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.cef;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.simantics.district.network.cef.DistrictClientHtmlServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractUIPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    public static final String PLUGIN_ID = "org.simantics.diagram.cef";
    private static Activator plugin;
    private static CompletableFuture<DistrictClientHtmlServer> serverFuture;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (serverFuture == null) {
            serverFuture = new CompletableFuture();
            ForkJoinPool.commonPool().submit(() -> {
                try {
                    DistrictClientHtmlServer server = new DistrictClientHtmlServer();
                    server.start();
                    ((CompletableFuture)org.simantics.district.network.grpc.Activator.startServers().exceptionally(thr -> {
                        serverFuture.completeExceptionally((Throwable)thr);
                        return null;
                    })).thenRun(() -> serverFuture.complete(server));
                }
                catch (IOException | URISyntaxException e) {
                    LOGGER.error("Could not start grpc server", (Throwable)e);
                    serverFuture.completeExceptionally(e);
                }
            });
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (!serverFuture.isCancelled() && !serverFuture.isCompletedExceptionally()) {
            serverFuture.get().stop();
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static CompletableFuture<DistrictClientHtmlServer> getServer() {
        return serverFuture;
    }

    public static Path getPluginMetadataPath() {
        return Platform.getStateLocation((Bundle)plugin.getBundle()).toFile().toPath();
    }

    public static Path getClientBuildFolder() throws IOException, URISyntaxException {
        return Activator.getEntry("/client/build");
    }

    private static Path getEntry(String path) throws IOException, URISyntaxException {
        URL entryURL = plugin.getBundle().getEntry(path);
        URL entryFileURL = FileLocator.toFileURL((URL)entryURL);
        URI encodedUri = new URI(entryFileURL.getProtocol(), entryFileURL.getPath(), null).normalize();
        return Paths.get(encodedUri);
    }
}

