/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.function;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.util.Range;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.issue.StandardIssue;
import org.simantics.db.common.primitiverequest.PossibleRelatedValueImplied2;
import org.simantics.db.common.primitiverequest.PossibleResource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.IsEnumeratedValue;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.NearestOwnerFinder;
import org.simantics.db.common.validation.L0Validations;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.DoesNotContainValueException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.layer0.exception.InvalidVariableException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.exception.MissingVariableValueException;
import org.simantics.db.layer0.exception.PendingVariableException;
import org.simantics.db.layer0.function.StandardChildDomainChildren;
import org.simantics.db.layer0.request.PossibleURI;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.request.UnescapedAssertedPropertyMapOfResource;
import org.simantics.db.layer0.request.UnescapedMethodMapOfResource;
import org.simantics.db.layer0.request.UnescapedPropertyMapOfResource;
import org.simantics.db.layer0.scl.CompileResourceValueRequest;
import org.simantics.db.layer0.scl.CompileValueRequest;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.PrimitiveValueParser;
import org.simantics.db.layer0.variable.AbstractVariable;
import org.simantics.db.layer0.variable.ChildVariableMapRequest;
import org.simantics.db.layer0.variable.ExternalSetValue;
import org.simantics.db.layer0.variable.PropertyVariableMapRequest;
import org.simantics.db.layer0.variable.StandardAssertedGraphPropertyVariable;
import org.simantics.db.layer0.variable.StandardComposedProperty;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.SubliteralPropertyVariable;
import org.simantics.db.layer0.variable.SubliteralPropertyVariableDeprecated;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableBuilder;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.VariableMapImpl;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.layer0.variable.VariableNodeReadRunnable;
import org.simantics.db.layer0.variable.VariableUtils;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.ExternalOperation;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function4;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.scl.runtime.function.FunctionImpl2;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.strings.StringInputValidator;

public class All {
    @SCLValue(type="ValueAccessor")
    public static ValueAccessor standardValueAccessor = new ValueAccessor(){

        @Override
        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            ValueAccessor accessor = All.getPossibleValueValueAccessor(graph, context);
            if (accessor != null) {
                return accessor.getValue(graph, context);
            }
            return All.standardGetValue1(graph, context);
        }

        @Override
        public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
            ValueAccessor accessor = All.getPossibleValueValueAccessor(graph, context);
            if (accessor != null) {
                return accessor.getValue(graph, context, binding);
            }
            return All.standardGetValue2(graph, context, binding);
        }

        @Override
        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
            ValueAccessor accessor = All.getPossibleValueValueAccessor((ReadGraph)graph, context);
            if (accessor != null) {
                accessor.setValue(graph, context, value);
            } else {
                All.standardSetValue2(graph, context, value);
            }
        }

        @Override
        public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
            ValueAccessor accessor = All.getPossibleValueValueAccessor((ReadGraph)graph, context);
            if (accessor != null) {
                accessor.setValue(graph, context, value, binding);
            } else {
                All.standardSetValue3(graph, context, value, binding);
            }
        }

        @Override
        public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
            ValueAccessor accessor = All.getPossibleValueValueAccessor(graph, context);
            if (accessor != null) {
                return accessor.getDatatype(graph, context);
            }
            return All.standardGetDatatype(graph, context);
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap standardChildDomainProperties = new VariableMapImpl(){

        @Override
        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            return All.getStandardChildDomainPropertyVariable(graph, context, name);
        }

        @Override
        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            return All.getStandardChildDomainPropertyVariables(graph, context, map);
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap methodsPropertyDomainProperties = new VariableMapImpl(){

        @Override
        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            Variable parent = context.getParent(graph);
            Resource container = parent.getPossibleRepresents(graph);
            if (container == null) {
                return null;
            }
            Map methods = (Map)graph.syncRequest((Read)new UnescapedMethodMapOfResource(container));
            Resource predicate = (Resource)methods.get(name);
            if (predicate != null) {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(L0.Entity_method));
                Resource value = graph.getSingleObject(container, predicate);
                return new StandardGraphPropertyVariable(context, null, container, info, value);
            }
            return null;
        }

        @Override
        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            Variable parent = context.getParent(graph);
            Resource container = parent.getPossibleRepresents(graph);
            if (container == null) {
                return Collections.emptyMap();
            }
            Map methods = (Map)graph.syncRequest((Read)new UnescapedMethodMapOfResource(container));
            for (Map.Entry entry : methods.entrySet()) {
                String name = (String)entry.getKey();
                Resource predicate = (Resource)entry.getValue();
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(L0.Entity_method));
                Resource value = graph.getSingleObject(container, predicate);
                if (map == null) {
                    map = new HashMap<String, Variable>();
                }
                map.put(name, new StandardGraphPropertyVariable(context, null, container, info, value));
            }
            return map;
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap standardPropertyDomainProperties = new VariableMapImpl(){

        VariableMap getValueVariableMap(ReadGraph graph, Variable context) throws DatabaseException {
            VariableMap map;
            Resource represents = context.getPossibleRepresents(graph);
            if (represents == null) {
                return null;
            }
            VariableMap variableMap = map = graph.isImmutable(represents) ? (VariableMap)graph.syncRequest((Read)new PropertyVariableMapRequest(represents), (Listener)TransientCacheListener.instance()) : (VariableMap)graph.getPossibleRelatedValue2(represents, Layer0.getInstance((ReadGraph)graph).domainProperties, (Object)represents);
            if (map == standardPropertyDomainProperties) {
                return null;
            }
            return map;
        }

        @Override
        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            VariableMap valueMap = this.getValueVariableMap(graph, context);
            if (valueMap != null) {
                return valueMap.getVariable(graph, context, name);
            }
            return All.getStandardPropertyDomainPropertyVariableFromValue(graph, context, name);
        }

        @Override
        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            VariableMap valueMap = this.getValueVariableMap(graph, context);
            if (valueMap != null) {
                return valueMap.getVariables(graph, context, map);
            }
            return All.getStandardPropertyDomainPropertyVariablesFromValue(graph, context, map);
        }

        @Override
        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, String classification, Map<String, Variable> map) throws DatabaseException {
            VariableMap valueMap = this.getValueVariableMap(graph, context);
            if (valueMap != null) {
                return valueMap.getVariables(graph, context, classification, map);
            }
            return All.getStandardPropertyDomainPropertyVariablesFromValue(graph, context, classification, map);
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap standardChildDomainChildren = new VariableMapImpl(){

        @Override
        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            return StandardChildDomainChildren.getStandardChildDomainChildVariable(graph, context, name);
        }

        @Override
        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            return StandardChildDomainChildren.getStandardChildDomainChildVariables(graph, context, map);
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap standardPropertyDomainChildren = new VariableMapImpl(){

        VariableMap getValueVariableMap(ReadGraph graph, Variable context) throws DatabaseException {
            Resource represents = context.getPossibleRepresents(graph);
            if (represents == null) {
                return null;
            }
            VariableMap map = (VariableMap)graph.syncRequest((Read)new ChildVariableMapRequest(represents));
            if (map == standardPropertyDomainChildren) {
                return null;
            }
            return map;
        }

        @Override
        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            VariableMap valueMap = this.getValueVariableMap(graph, context);
            if (valueMap != null) {
                return valueMap.getVariable(graph, context, name);
            }
            if (context instanceof StandardGraphPropertyVariable) {
                Object childNode;
                ChildReference ref;
                StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
                Datatype dt = variable.getDatatype(graph);
                if (dt instanceof ArrayType && (ref = All.getPossibleIndexReference(name)) != null) {
                    return new SubliteralPropertyVariableDeprecated(variable, ref);
                }
                if (variable.node != null && (childNode = All.getPossibleNodeChild(graph, variable, name)) != null) {
                    return All.createStandardGraphChildVariable(variable, childNode);
                }
                return standardChildDomainChildren.getVariable(graph, context, name);
            }
            if (context instanceof StandardGraphChildVariable) {
                return standardChildDomainChildren.getVariable(graph, context, name);
            }
            throw new DatabaseException("Unknown variable implementation " + context.getClass().getCanonicalName());
        }

        @Override
        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            VariableMap valueMap = this.getValueVariableMap(graph, context);
            if (valueMap != null) {
                return valueMap.getVariables(graph, context, map);
            }
            if (context instanceof StandardGraphPropertyVariable) {
                Map<String, Variable> result = All.getStandardNodeChildVariables(graph, context, map);
                return standardChildDomainChildren.getVariables(graph, context, result);
            }
            if (context instanceof StandardGraphChildVariable) {
                return standardChildDomainChildren.getVariables(graph, context, map);
            }
            throw new DatabaseException("Unknown variable implementation " + context.getClass().getCanonicalName());
        }
    };

    public static Object standardGetValue1(ReadGraph graph, Variable context) throws DatabaseException {
        StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
        if (variable.node != null) {
            Variant value = Variables.requestNodeValue(graph, variable.node);
            if (Variables.PENDING_NODE_VALUE == value) {
                throw new PendingVariableException("");
            }
            return value.getValue();
        }
        try {
            Resource object;
            if (variable.property.hasEnumerationRange && ((Boolean)graph.sync((ReadInterface)new IsEnumeratedValue(object = variable.getRepresents(graph)))).booleanValue()) {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(object, L0.Literal)) {
                    return graph.getValue(object);
                }
                String label = (String)graph.getPossibleRelatedValue2(variable.getRepresents(graph), L0.HasLabel, (Binding)Bindings.STRING);
                if (label == null) {
                    label = (String)graph.getPossibleRelatedValue(variable.getRepresents(graph), L0.HasName, (Binding)Bindings.STRING);
                }
                if (label == null) {
                    label = "<no label>";
                }
                return label;
            }
            if (variable.isAsserted() && variable.parentResource != null) {
                Map assertions = (Map)graph.syncRequest((Read)new UnescapedAssertedPropertyMapOfResource(variable.parentResource), (AsyncProcedure)TransientCacheAsyncListener.instance());
                Resource object2 = variable.getPossibleRepresents(graph);
                if (object2 != null) {
                    return graph.getValue2(object2, (Object)variable);
                }
                for (Pair assertion : assertions.values()) {
                    if (!((PropertyInfo)assertion.first).predicate.equals(variable.getPossiblePredicateResource(graph))) continue;
                    return graph.getValue2((Resource)assertion.second, (Object)variable);
                }
            }
            return graph.getValue2(variable.getRepresents(graph), (Object)variable);
        }
        catch (NoSingleResultException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph), e);
        }
        catch (DoesNotContainValueException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph), e);
        }
        catch (DatabaseException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph), e);
        }
    }

    public static Object standardGetValue2(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
        StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
        if (variable.node != null) {
            try {
                Variant value = Variables.requestNodeValue(graph, variable.node, binding);
                if (Variables.PENDING_NODE_VALUE == value) {
                    throw new PendingVariableException("");
                }
                if (value == null) {
                    throw new MissingVariableValueException(variable.getPossibleURI(graph));
                }
                return value.getValue(binding);
            }
            catch (AdaptException e) {
                throw new AdaptionException("Could not get value for " + context.getURI(graph), (Throwable)e);
            }
        }
        try {
            Resource object;
            if (variable.property.hasEnumerationRange && ((Boolean)graph.sync((ReadInterface)new IsEnumeratedValue(object = variable.getRepresents(graph)))).booleanValue()) {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(object, L0.Literal)) {
                    return graph.getValue(object, binding);
                }
                return graph.getRelatedValue2(variable.getRepresents(graph), L0.HasLabel, binding);
            }
            if (variable.isAsserted() && variable.parentResource != null) {
                Map assertions = (Map)graph.syncRequest((Read)new UnescapedAssertedPropertyMapOfResource(variable.parentResource), (AsyncProcedure)TransientCacheAsyncListener.instance());
                Resource object2 = variable.getPossibleRepresents(graph);
                if (object2 != null) {
                    return graph.getValue2(object2, (Object)variable, binding);
                }
                for (Pair assertion : assertions.values()) {
                    if (!((PropertyInfo)assertion.first).predicate.equals(variable.getPossiblePredicateResource(graph))) continue;
                    return graph.getValue2((Resource)assertion.second, (Object)variable, binding);
                }
            }
            return graph.getValue2(variable.getRepresents(graph), (Object)context, binding);
        }
        catch (NoSingleResultException noSingleResultException) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph));
        }
        catch (DoesNotContainValueException doesNotContainValueException) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph));
        }
        catch (DatabaseException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph), e);
        }
    }

    public static void standardSetValue2(WriteGraph graph, Variable context, final Object value) throws DatabaseException {
        Function4<WriteGraph, Variable, Object, Object, String> modifier;
        if (context instanceof StandardGraphPropertyVariable) {
            final StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
            if (variable.node != null) {
                final Binding binding = Layer0Utils.getDefaultBinding((ReadGraph)graph, variable);
                final AtomicReference oldValueRef = new AtomicReference();
                try {
                    variable.node.support.manager.getRealm().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                oldValueRef.set(All.getNodeValue(variable, binding));
                                All.setNodeValue(variable, value, binding);
                            }
                            catch (NodeManagerException e) {
                                throw new RuntimeException(e);
                            }
                            catch (org.simantics.databoard.binding.error.BindingException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof NodeManagerException || e.getCause() instanceof org.simantics.databoard.binding.error.BindingException) {
                        throw new DatabaseException(e.getCause());
                    }
                    throw e;
                }
                catch (InterruptedException e) {
                    throw new DatabaseException((Throwable)e);
                }
                ExternalSetValue ext = new ExternalSetValue(variable.node.support.manager, variable.node.node, oldValueRef.get(), value, binding);
                ((UndoRedoSupport)graph.getService(UndoRedoSupport.class)).addExternalOperation(graph, (ExternalOperation)ext);
                return;
            }
        }
        if ((modifier = (Function4<WriteGraph, Variable, Object, Object, String>)context.getPossiblePropertyValue((ReadGraph)graph, "HasInputModifier")) == null) {
            modifier = VariableUtils.defaultInputModifier;
        }
        try {
            modifier.apply((Object)graph, (Object)context, value, (Object)Bindings.getBinding(value.getClass()));
        }
        catch (BindingConstructionException e) {
            throw new BindingException("", (Throwable)e);
        }
    }

    public static void standardSetValue3(final WriteGraph graph, Variable context, final Object value, final Binding binding) throws DatabaseException {
        Function4<WriteGraph, Variable, Object, Object, String> modifier;
        if (context instanceof StandardGraphPropertyVariable) {
            final StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
            if (variable.node != null) {
                try {
                    variable.node.support.manager.getRealm().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Object oldValue = All.getNodeValue(variable, binding);
                                All.setNodeValue(variable, value, binding);
                                ExternalSetValue ext = new ExternalSetValue(variable.node.support.manager, variable.node.node, oldValue, value, binding);
                                ((UndoRedoSupport)graph.getService(UndoRedoSupport.class)).addExternalOperation(graph, (ExternalOperation)ext);
                            }
                            catch (org.simantics.databoard.binding.error.BindingException | NodeManagerException e) {
                                Logger.defaultLogError((Throwable)e);
                            }
                        }
                    });
                    return;
                }
                catch (InterruptedException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        }
        if ((modifier = (Function4<WriteGraph, Variable, Object, Object, String>)context.getPossiblePropertyValue((ReadGraph)graph, "HasInputModifier")) == null) {
            modifier = VariableUtils.defaultInputModifier;
        }
        modifier.apply((Object)graph, (Object)context, value, (Object)binding);
    }

    public static Datatype getDatatypeFromValue(ReadGraph graph, Variable context) throws DatabaseException {
        Binding defaultBinding;
        if (context instanceof AbstractVariable && (defaultBinding = ((AbstractVariable)context).getPossibleDefaultBinding(graph)) != null) {
            return defaultBinding.type();
        }
        Variant value = context.getVariantValue(graph);
        if (value.getBinding() == null) {
            throw new DatabaseException("No value binding for " + context.getURI(graph));
        }
        return value.getBinding().type();
    }

    public static Datatype standardGetDatatype(ReadGraph graph, Variable context) throws DatabaseException {
        if (context instanceof AbstractVariable) {
            AbstractVariable variable = (AbstractVariable)context;
            if (variable.node != null) {
                try {
                    DatatypeGetter request = new DatatypeGetter(variable.node);
                    variable.node.support.manager.getRealm().syncExec((Runnable)request);
                    if (request.exception != null) {
                        throw new DatabaseException((Throwable)request.exception);
                    }
                    return request.type;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return All.getDatatypeFromValue(graph, context);
    }

    public static Variable getStandardChildDomainPropertyVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
        StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
        PropertyInfo graphProperty = All.getPossiblePropertyInfoFromContext(graph, variable, variable.resource, name);
        return All.getStandardChildDomainPropertyVariable(graph, context, graphProperty, name);
    }

    public static Resource getPossiblePropertyResource(ReadGraph graph, AbstractVariable parent, Object node) throws DatabaseException {
        String propertyURI;
        if (parent != null && parent.node != null && parent.node.node != null && parent.node.support != null && (propertyURI = All.getPossiblePropertyURI(parent, node)) != null) {
            return graph.getPossibleResource(propertyURI);
        }
        return null;
    }

    public static Variable getStandardChildDomainPropertyVariable(ReadGraph graph, Variable context, PropertyInfo graphProperty, String name) throws DatabaseException {
        StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
        Object propertyNode = All.getPossibleNodeProperty(graph, variable, name, true);
        if (graphProperty != null && graphProperty.builder != null) {
            return All.buildPropertyVariable(graph, variable, variable.resource, graphProperty, propertyNode);
        }
        if (propertyNode != null) {
            return All.createStandardGraphPropertyVariable(graph, variable, propertyNode);
        }
        if (variable.node != null) {
            try {
                Set classifications = variable.node.support.manager.getClassifications(variable.node.node);
                if (!classifications.isEmpty()) {
                    for (String uri : classifications) {
                        Map pm;
                        Pair pi;
                        Resource type = (Resource)graph.syncRequest((AsyncRead)new PossibleResource(uri), (AsyncListener)TransientCacheAsyncListener.instance());
                        if (type == null || (pi = (Pair)(pm = (Map)graph.syncRequest((Read)new UnescapedAssertedPropertyMapOfResource(type), (AsyncProcedure)TransientCacheAsyncListener.instance())).get(name)) == null) continue;
                        return new StandardAssertedGraphPropertyVariable(graph, context, null, type, ((PropertyInfo)pi.first).predicate, (Resource)pi.second);
                    }
                }
            }
            catch (NodeManagerException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        return null;
    }

    public static Map<String, Variable> getStandardChildDomainPropertyVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
        return All.getStandardChildDomainPropertyVariables(graph, context, null, map);
    }

    public static Map<String, Variable> getStandardChildDomainPropertyVariables(ReadGraph graph, Variable context, String classification, Map<String, Variable> map) throws DatabaseException {
        StandardGraphChildVariable variable = (StandardGraphChildVariable)context;
        Collection<Object> nodeProperties = All.getPossibleNodeProperties(graph, variable);
        if (!nodeProperties.isEmpty()) {
            String name;
            Map<String, PropertyInfo> graphProperties = All.collectPropertyInfosFromContext(graph, variable, variable.resource);
            THashSet used = new THashSet(nodeProperties.size());
            map = All.ensureVariableMap(map, graphProperties.size() + nodeProperties.size());
            for (Object nodeProperty : nodeProperties) {
                name = All.getNodeName(variable, nodeProperty);
                used.add(name);
                PropertyInfo graphProperty = graphProperties.get(name);
                if (graphProperty != null && graphProperty.builder != null) {
                    if (classification != null && !graphProperty.hasClassification(classification)) continue;
                    map.put(name, All.buildPropertyVariable(graph, variable, variable.resource, graphProperty, nodeProperty));
                    continue;
                }
                map.put(name, All.createStandardGraphPropertyVariable(graph, variable, nodeProperty));
            }
            for (PropertyInfo info : graphProperties.values()) {
                name = info.name;
                if (used != null && used.contains(name) || classification != null && !info.hasClassification(classification) || info.builder == null) continue;
                map.put(name, All.buildPropertyVariable(graph, variable, variable.resource, info, null));
            }
            return map;
        }
        if (variable.resource == null) {
            return map;
        }
        Collection predicates = graph.getPredicates(variable.resource);
        if (predicates.isEmpty()) {
            return map;
        }
        map = All.ensureVariableMap(map, predicates.size());
        for (Resource predicate : predicates) {
            PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(predicate), (AsyncProcedure)TransientCacheAsyncListener.instance());
            if (!info.isHasProperty || classification != null && !info.hasClassification(classification) || info.builder == null) continue;
            map.put(info.name, All.buildPropertyVariable(graph, variable, variable.resource, info, null));
        }
        return map;
    }

    public static Variable getStandardPropertyDomainPropertyVariableFromValue(ReadGraph graph, Variable context, String name) throws DatabaseException {
        if (context instanceof StandardGraphPropertyVariable) {
            Variable result;
            StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
            Resource literal = variable.getPossibleRepresents(graph);
            Object propertyNode = All.getPossibleNodeProperty(graph, variable, name, false);
            if (literal != null && (result = All.getPossiblePropertyFromContext(graph, variable, literal, name, propertyNode)) != null) {
                return result;
            }
            result = All.getPossibleSubliteralPropertyFromContext(graph, variable, name);
            if (result != null) {
                return result;
            }
            result = All.getPossiblePropertyFromContext(graph, variable, variable.property.predicate, name, propertyNode);
            if (result != null) {
                return result;
            }
            if (propertyNode != null) {
                return All.createStandardGraphPropertyVariable(graph, variable, propertyNode);
            }
            return null;
        }
        if (context instanceof StandardGraphChildVariable) {
            return standardChildDomainProperties.getVariable(graph, context, name);
        }
        throw new DatabaseException("Unknown variable implementation " + context.getClass().getCanonicalName());
    }

    public static Map<String, Variable> getStandardPropertyDomainPropertyVariablesFromValue(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
        if (context instanceof StandardGraphPropertyVariable) {
            StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
            map = All.collectPropertiesFromContext(graph, variable, variable.property.predicate, map);
            if (variable.parentResource != null) {
                Resource literal = graph.getPossibleObject(variable.parentResource, variable.property.predicate);
                if (literal != null) {
                    map = All.collectPropertiesFromContext(graph, variable, literal, map);
                }
                map = All.collectSubliteralProperties(graph, variable, map);
            }
            map = All.getStandardNodePropertyVariables(graph, context, map);
            return map;
        }
        if (context instanceof StandardGraphChildVariable) {
            return standardChildDomainProperties.getVariables(graph, context, map);
        }
        throw new DatabaseException("Unknown variable implementation " + context.getClass().getCanonicalName());
    }

    public static Map<String, Variable> getStandardPropertyDomainPropertyVariablesFromValue(ReadGraph graph, Variable context, String classification, Map<String, Variable> map) throws DatabaseException {
        if (context instanceof StandardGraphPropertyVariable) {
            Resource literal;
            StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
            map = All.collectPropertiesFromContext(graph, variable, variable.property.predicate, classification, map);
            if (variable.parentResource != null && (literal = graph.getPossibleObject(variable.parentResource, variable.property.predicate)) != null) {
                map = All.collectPropertiesFromContext(graph, variable, literal, classification, map);
            }
            map = All.getStandardNodePropertyVariables(graph, context, map);
            return map;
        }
        if (context instanceof StandardGraphChildVariable) {
            return standardChildDomainProperties.getVariables(graph, context, map);
        }
        throw new DatabaseException("Unknown variable implementation " + context.getClass().getCanonicalName());
    }

    public static Resource getPossibleGraphChild(ReadGraph graph, Variable variable, String name) throws DatabaseException {
        Resource resource = variable.getPossibleRepresents(graph);
        if (resource == null) {
            return null;
        }
        Map graphChildren = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(resource));
        return (Resource)graphChildren.get(name);
    }

    public static Map<String, Resource> getPossibleGraphChildren(ReadGraph graph, Variable variable) throws DatabaseException {
        Resource resource = variable.getPossibleRepresents(graph);
        if (resource == null) {
            return Collections.emptyMap();
        }
        return (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(resource));
    }

    public static Object getPossibleNodeChild(ReadGraph graph, Variable variable, String name) throws DatabaseException {
        if (!(variable instanceof AbstractVariable)) {
            return null;
        }
        VariableNode node = ((AbstractVariable)variable).node;
        if (node == null) {
            return null;
        }
        Variables.NodeStructure structure = Variables.requestNodeStructure(graph, node);
        if (Variables.PENDING_NODE_STRUCTURE == structure) {
            throw new PendingVariableException("");
        }
        return structure.children.get(name);
    }

    public static Collection<Object> getPossibleNodeChildren(ReadGraph graph, Variable variable) throws DatabaseException {
        if (!(variable instanceof AbstractVariable)) {
            return null;
        }
        VariableNode node = ((AbstractVariable)variable).node;
        if (node == null) {
            return Collections.emptyList();
        }
        Variables.NodeStructure structure = Variables.requestNodeStructure(graph, node);
        if (Variables.PENDING_NODE_STRUCTURE == structure) {
            throw new PendingVariableException("");
        }
        return structure.children.values();
    }

    public static Object getPossibleNodeProperty(ReadGraph graph, Variable variable, String name, boolean throwPending) throws DatabaseException {
        if (!(variable instanceof AbstractVariable)) {
            return null;
        }
        VariableNode node = ((AbstractVariable)variable).node;
        if (node == null) {
            return null;
        }
        Variables.NodeStructure structure = Variables.requestNodeStructure(graph, node);
        if (throwPending && Variables.PENDING_NODE_STRUCTURE == structure) {
            throw new PendingVariableException("");
        }
        return structure.properties.get(name);
    }

    public static Collection<Object> getPossibleNodeProperties(ReadGraph graph, Variable variable) throws DatabaseException {
        if (!(variable instanceof AbstractVariable)) {
            return null;
        }
        VariableNode node = ((AbstractVariable)variable).node;
        if (node == null) {
            return Collections.emptyList();
        }
        Variables.NodeStructure structure = Variables.requestNodeStructure(graph, node);
        if (Variables.PENDING_NODE_STRUCTURE == structure) {
            throw new PendingVariableException("");
        }
        return structure.properties.values();
    }

    public static VariableNode build(VariableNode parent, Object node) {
        if (node == null) {
            return null;
        }
        return new VariableNode(parent.support, node);
    }

    @Deprecated
    public static Variable getStandardChildDomainChildVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
        return StandardChildDomainChildren.getStandardChildDomainChildVariable(graph, context, name);
    }

    @Deprecated
    public static Variable getStandardChildDomainChildVariable(ReadGraph graph, Variable context, Resource graphChild, String name) throws DatabaseException {
        return StandardChildDomainChildren.getStandardChildDomainChildVariable(graph, context, graphChild, name);
    }

    @Deprecated
    public static Map<String, Variable> getStandardChildDomainChildVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
        return StandardChildDomainChildren.getStandardChildDomainChildVariables(graph, context, map);
    }

    @Deprecated
    public static Map<String, Variable> getStandardChildDomainChildVariables(ReadGraph graph, Variable context, Map<String, Resource> graphChildren, Map<String, Variable> map) throws DatabaseException {
        return StandardChildDomainChildren.getStandardChildDomainChildVariables(graph, context, graphChildren, map);
    }

    public static Map<String, Variable> getStandardNodeChildVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
        AbstractVariable variable = (AbstractVariable)context;
        if (variable.node == null) {
            return map;
        }
        Collection<Object> nodeChildren = All.getPossibleNodeChildren(graph, variable);
        if (nodeChildren.isEmpty()) {
            return map;
        }
        map = All.ensureVariableMap(map, nodeChildren.size());
        for (Object nodeChild : nodeChildren) {
            String name = All.getNodeName(variable, nodeChild);
            if (map.containsKey(name)) continue;
            map.put(name, All.createStandardGraphChildVariable(variable, nodeChild));
        }
        return map;
    }

    public static Map<String, Variable> getStandardNodePropertyVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
        AbstractVariable variable = (AbstractVariable)context;
        if (variable.node == null) {
            return map;
        }
        Collection<Object> nodeProperties = All.getPossibleNodeProperties(graph, variable);
        if (nodeProperties.isEmpty()) {
            return map;
        }
        map = All.ensureVariableMap(map, nodeProperties.size());
        for (Object nodeProperty : nodeProperties) {
            String name = All.getNodeName(variable, nodeProperty);
            if (map.containsKey(name)) continue;
            map.put(name, All.createStandardGraphPropertyVariable(graph, variable, nodeProperty));
        }
        return map;
    }

    protected static ChildReference getPossibleIndexReference(String name) {
        if (name.startsWith("i-")) {
            try {
                int index = Integer.parseInt(name.substring(2));
                return new IndexReference(index);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    protected static ValueAccessor getPossiblePropertyValueAccessor(ReadGraph graph, StandardGraphPropertyVariable variable) throws DatabaseException {
        if (variable.property == null) {
            return null;
        }
        return variable.property.valueAccessor;
    }

    public static ValueAccessor getPossibleValueValueAccessor(ReadGraph graph, Variable variable) throws DatabaseException {
        Resource value = variable.getPossibleRepresents(graph);
        if (value == null) {
            return null;
        }
        return (ValueAccessor)graph.syncRequest((Read)new PossibleRelatedValueImplied2(value, Layer0.getInstance((ReadGraph)graph).valueAccessor));
    }

    public static PropertyInfo getPossiblePropertyInfoFromContext(ReadGraph graph, Variable variable, Resource context, String name) throws DatabaseException {
        if (context == null) {
            return null;
        }
        Map predicates = (Map)graph.syncRequest((Read)new UnescapedPropertyMapOfResource(context), (Listener)TransientCacheListener.instance());
        return (PropertyInfo)predicates.get(name);
    }

    public static Variable getPossiblePropertyFromContext(ReadGraph graph, Variable variable, Resource context, String name, Object propertyNode) throws DatabaseException {
        PropertyInfo info = All.getPossiblePropertyInfoFromContext(graph, variable, context, name);
        if (info == null || info.builder == null) {
            return null;
        }
        return All.buildPropertyVariable(graph, variable, context, info, propertyNode);
    }

    public static Variable getPossibleSubliteralPropertyFromContext(ReadGraph graph, StandardGraphPropertyVariable variable, String name) throws DatabaseException {
        Resource predicate = variable.property.predicate;
        if (predicate == null) {
            return null;
        }
        PropertyInfo info = All.getPropertyInfo(graph, predicate);
        Pair<Resource, ChildReference> p = info.subliteralPredicates.get(name);
        if (p == null) {
            return null;
        }
        return new SubliteralPropertyVariable(graph, (Variable)variable, (Resource)p.first, (ChildReference)p.second);
    }

    public static Map<String, PropertyInfo> collectPropertyInfosFromContext(ReadGraph graph, Variable variable, Resource context) throws DatabaseException {
        if (context == null) {
            return Collections.emptyMap();
        }
        return graph.isImmutable(context) ? (Map)graph.syncRequest((Read)new UnescapedPropertyMapOfResource(context), (AsyncProcedure)TransientCacheAsyncListener.instance()) : (Map)graph.syncRequest((Read)new UnescapedPropertyMapOfResource(context));
    }

    public static Map<String, Variable> collectPropertiesFromContext(ReadGraph graph, Variable variable, Resource context, Map<String, Variable> map) throws DatabaseException {
        Map properties;
        Map map2 = properties = graph.isImmutable(context) ? (Map)graph.syncRequest((Read)new UnescapedPropertyMapOfResource(context), (AsyncProcedure)TransientCacheAsyncListener.instance()) : (Map)graph.syncRequest((Read)new UnescapedPropertyMapOfResource(context));
        if (properties.isEmpty()) {
            return map;
        }
        map = All.ensureVariableMap(map, properties.size());
        for (PropertyInfo info : properties.values()) {
            String name = info.name;
            if (info.builder == null) continue;
            Variable v = info.builder.buildProperty(graph, variable, null, context, info.predicate);
            map.put(name, v);
        }
        return map;
    }

    public static Map<String, Variable> collectSubliteralProperties(ReadGraph graph, StandardGraphPropertyVariable variable, Map<String, Variable> map) throws DatabaseException {
        Resource predicate = variable.property.predicate;
        if (predicate == null) {
            return map;
        }
        PropertyInfo info = All.getPropertyInfo(graph, predicate);
        if (info.subliteralPredicates.isEmpty()) {
            return map;
        }
        map = All.ensureVariableMap(map, info.subliteralPredicates.size());
        for (Map.Entry<String, Pair<Resource, ChildReference>> entry : info.subliteralPredicates.entrySet()) {
            String key = entry.getKey();
            Pair<Resource, ChildReference> p = entry.getValue();
            if (map == null) {
                map = new THashMap();
            }
            map.put(key, new SubliteralPropertyVariable(graph, (Variable)variable, (Resource)p.first, (ChildReference)p.second));
        }
        return map;
    }

    public static Map<String, Variable> collectPropertiesFromContext(ReadGraph graph, Variable variable, Resource context, String classification, Map<String, Variable> map) throws DatabaseException {
        if (graph.isImmutable(context)) {
            Map properties = (Map)graph.syncRequest((Read)new UnescapedPropertyMapOfResource(context), (AsyncProcedure)TransientCacheAsyncListener.instance());
            for (PropertyInfo info : properties.values()) {
                if (!info.classifications.contains(classification) || info.builder == null) continue;
                String name = info.name;
                Variable v = info.builder.buildProperty(graph, variable, null, context, info.predicate);
                if (map == null) {
                    map = new THashMap();
                }
                map.put(name, v);
            }
        } else {
            Collection predicates = graph.getPredicates(context);
            if (predicates.isEmpty()) {
                return map;
            }
            map = All.ensureVariableMap(map, predicates.size());
            for (Resource predicate : predicates) {
                PropertyInfo info;
                PropertyInfo propertyInfo = info = graph.isImmutable(predicate) ? (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(predicate), (AsyncProcedure)TransientCacheAsyncListener.instance()) : (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(predicate));
                if (!info.isHasProperty || !info.classifications.contains(classification) || info.builder == null) continue;
                String name = info.name;
                Variable v = info.builder.buildProperty(graph, variable, null, context, info.predicate);
                if (map == null) {
                    map = new THashMap();
                }
                map.put(name, v);
            }
        }
        return map;
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> String")
    public static String entityLabel(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        if (context instanceof Resource) {
            return NameUtils.getSafeLabel((ReadGraph)graph, (Resource)((Resource)context));
        }
        if (context instanceof Variable) {
            Variable parent = ((Variable)context).getParent(graph);
            Resource represents = parent.getRepresents(graph);
            return NameUtils.getSafeLabel((ReadGraph)graph, (Resource)represents);
        }
        throw new DatabaseException("Unknown context " + context);
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object listResources(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return ListUtils.toList((ReadGraph)graph, (Resource)resource);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> [String]")
    public static List<String> standardClassifications(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        ArrayList<String> result = new ArrayList<String>();
        Resource predicate = context.getParent(graph).getPossiblePredicateResource(graph);
        if (predicate != null) {
            for (Resource type : graph.getTypes(predicate)) {
                String uri = graph.getPossibleURI(type);
                if (uri == null) continue;
                result.add(uri);
            }
        }
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> Boolean")
    public static Boolean standardValidValue(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return Boolean.TRUE;
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> StringInputValidator")
    public static StringInputValidator standardValidator(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return StringInputValidator.PASS;
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> Boolean")
    public static Boolean standardRequiredValue(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return Boolean.FALSE;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Boolean")
    public static Boolean standardDefaultValue(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable property = context.getParent(graph);
        if (property instanceof StandardGraphPropertyVariable) {
            Resource predicate;
            StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)property;
            if (variable.parentResource != null && (predicate = variable.getPossiblePredicateResource(graph)) != null) {
                Statement stm = graph.getPossibleStatement(variable.parentResource, predicate);
                if (stm != null && stm.isAsserted(variable.parentResource)) {
                    return true;
                }
                return false;
            }
        }
        return Boolean.FALSE;
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> Boolean")
    public static Boolean standardReadOnlyValue(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return Boolean.FALSE;
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object resourceAsValue(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return resource;
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object functionApplication(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return Functions.exec((RequestProcessor)graph, (Resource)resource, (Object[])new Object[]{graph, resource, context});
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object computeExpression(ReadGraph graph, Resource converter, Object context) throws DatabaseException {
        if (context instanceof Variable) {
            return CompileValueRequest.compileAndEvaluate(graph, (Variable)context);
        }
        if (context instanceof Resource) {
            return CompileResourceValueRequest.compileAndEvaluate(graph, converter);
        }
        throw new IllegalStateException("Unknown context " + context);
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object composedPropertyValue(ReadGraph graph, Resource converter, Object context) throws DatabaseException {
        if (context instanceof Variable) {
            return new StandardComposedProperty();
        }
        if (context instanceof Resource) {
            return new StandardComposedProperty();
        }
        throw new IllegalStateException("Unknown context " + context);
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object numberInputValidator(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        class Validator
        extends FunctionImpl1<String, String> {
            private final Datatype datatype;

            public Validator(Datatype datatype) {
                this.datatype = datatype;
            }

            public String apply(String input) {
                if (this.datatype == null) {
                    return null;
                }
                try {
                    if (this.datatype instanceof NumberType) {
                        Number number = (Number)PrimitiveValueParser.parse(input, this.datatype);
                        NumberType nt = (NumberType)this.datatype;
                        Range r = nt.getRange();
                        if (r != null && !r.contains(number)) {
                            return "Value is out of valid range";
                        }
                    }
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    return "Not a valid floating-point number";
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return "Not a valid floating-point number";
                }
            }
        }
        if (context instanceof Variable) {
            Variable variable = (Variable)context;
            Variable property = variable.getParent(graph);
            Datatype datatype = property.getPossibleDatatype(graph);
            return new Validator(datatype);
        }
        if (context instanceof Resource) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Resource literal = (Resource)context;
            Datatype datatype = (Datatype)graph.getRelatedValue(literal, L0.HasDataType, Bindings.getBindingUnchecked(Datatype.class));
            return new Validator(datatype);
        }
        return new Validator(null);
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object booleanInputValidator(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        return new FunctionImpl1<String, String>(){

            public String apply(String input) {
                String lower = input.toLowerCase();
                if ("true".equals(lower) || "false".equals(lower)) {
                    return null;
                }
                return "Not a valid boolean: " + input;
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Resource")
    public static Resource hasStandardResource(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable parent = context.getParent(graph);
        if (parent instanceof StandardGraphChildVariable) {
            StandardGraphChildVariable variable = (StandardGraphChildVariable)parent;
            return variable.resource;
        }
        return null;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object valueWithoutBinding(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
        if (((Boolean)graph.sync((ReadInterface)new IsEnumeratedValue(variable.getRepresents(graph)))).booleanValue()) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            return graph.getRelatedValue2(variable.getRepresents(graph), L0.HasLabel);
        }
        if (variable.parentResource == null) {
            throw new InvalidVariableException("Variable is not represented by any resource (URI=" + variable.getPossibleURI(graph) + ").");
        }
        try {
            return graph.getRelatedValue2(variable.parentResource, variable.getPredicateResource(graph), (Object)variable);
        }
        catch (NoSingleResultException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph), e);
        }
        catch (DoesNotContainValueException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph), e);
        }
    }

    @SCLValue(type="ReadGraph -> Variable -> Binding -> a")
    public static Object valueWithBinding(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
        StandardGraphPropertyVariable variable = (StandardGraphPropertyVariable)context;
        if (((Boolean)graph.sync((ReadInterface)new IsEnumeratedValue(variable.getRepresents(graph)))).booleanValue()) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            return graph.getRelatedValue2(variable.getRepresents(graph), L0.HasLabel, binding);
        }
        if (variable.parentResource == null) {
            throw new MissingVariableException("Variable is not represented by any resource (URI=" + variable.getPossibleURI(graph) + ").", context.getPossibleRepresents(graph));
        }
        try {
            return graph.getRelatedValue2(variable.parentResource, variable.getPredicateResource(graph), (Object)variable);
        }
        catch (NoSingleResultException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph), e);
        }
        catch (DoesNotContainValueException e) {
            throw new MissingVariableValueException(variable.getPossibleURI(graph), e);
        }
    }

    @SCLValue(type="WriteGraph -> Variable -> a -> Binding -> b")
    public static Object valueSetterWithBinding(WriteGraph graph, Variable variable, Object value, Binding binding) throws DatabaseException {
        Function4<WriteGraph, Variable, Object, Object, String> modifier = (Function4<WriteGraph, Variable, Object, Object, String>)variable.getPossiblePropertyValue((ReadGraph)graph, "HasInputModifier");
        if (modifier == null) {
            modifier = VariableUtils.defaultInputModifier;
        }
        modifier.apply((Object)graph, (Object)variable, value, (Object)binding);
        return null;
    }

    private static List<Issue> reportInconsistency(ReadGraph graph, Resource subject, String description, List<Issue> issues) throws DatabaseException {
        if (issues == null) {
            issues = new ArrayList<Issue>();
        }
        System.err.println("Change set validation reports the following issue: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)subject, (boolean)true) + ": " + description);
        IssueResource IR = IssueResource.getInstance((ReadGraph)graph);
        issues.add((Issue)new L0Issue(description, IR.Issue, subject));
        return issues;
    }

    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> relationValidator(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        List<Issue> issues = null;
        for (Statement stm : graph.getStatements(resource, L0.IsWeaklyRelatedTo)) {
            Collection range;
            StringBuilder sb;
            Collection domain;
            Resource predicate = stm.getPredicate();
            Resource object = stm.getObject();
            if (!All.isRelation(graph, L0, predicate)) {
                issues = All.reportInconsistency(graph, resource, "The predicate of a statement must be a relation: " + NameUtils.toString((ReadGraph)graph, (Statement)stm), issues);
            }
            if (graph.isInstanceOf(predicate, L0.FunctionalRelation) && graph.getObjects(resource, predicate).size() > 1) {
                issues = All.reportInconsistency(graph, resource, "Relation " + NameUtils.getSafeName((ReadGraph)graph, (Resource)predicate) + " is functional.", issues);
            }
            if (!All.isInstanceOfAny(graph, resource, domain = graph.getObjects(predicate, L0.HasDomain), true)) {
                sb = new StringBuilder().append("The domain of ").append(NameUtils.getSafeName((ReadGraph)graph, (Resource)predicate)).append(" relation is ");
                All.orString(graph, sb, domain).append(".");
                issues = All.reportInconsistency(graph, resource, sb.toString(), issues);
            }
            if (All.isInstanceOfAny(graph, object, range = graph.getObjects(predicate, L0.HasRange), true) || graph.isInstanceOf(object, L0.SCLValue)) continue;
            sb = new StringBuilder().append("The range of ").append(NameUtils.getSafeName((ReadGraph)graph, (Resource)predicate)).append(" relation is ");
            All.orString(graph, sb, range).append(" but current object is ").append(NameUtils.getSafeName((ReadGraph)graph, (Resource)object)).append(".");
            issues = All.reportInconsistency(graph, resource, sb.toString(), issues);
        }
        return issues != null ? issues : Collections.emptyList();
    }

    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> propertyValidator(ReadGraph graph, Resource resource) throws DatabaseException {
        List<Issue> issues = null;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Statement stm : graph.getStatements(resource, L0.HasProperty)) {
            Resource predicate;
            Resource subject = stm.getSubject();
            String error = L0Validations.checkValueType((ReadGraph)graph, (Resource)subject, (Resource)(predicate = stm.getPredicate()));
            if (error == null) continue;
            issues = All.reportInconsistency(graph, subject, error, issues);
        }
        return issues != null ? issues : Collections.emptyList();
    }

    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> valueValidator(ReadGraph graph, Resource resource) throws DatabaseException {
        List<Issue> issues = null;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.hasValue(resource)) {
            if (!graph.isInstanceOf(resource, L0.Literal)) {
                issues = All.reportInconsistency(graph, resource, "Resource has a value but it is not a literal.", issues);
            }
        } else if (graph.isInstanceOf(resource, L0.Literal)) {
            issues = All.reportInconsistency(graph, resource, "Resource is a literal but it does not have a value.", issues);
        }
        return issues != null ? issues : Collections.emptyList();
    }

    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> uriValidator(ReadGraph graph, Resource resource) throws DatabaseException {
        String name;
        String parentURI;
        List<Issue> issues = null;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource parent = graph.getPossibleObject(resource, L0.PartOf);
        if (parent != null && (parentURI = (String)graph.syncRequest((Read)new PossibleURI(parent))) != null && (name = (String)graph.getPossibleRelatedValue(resource, L0.HasName)) == null) {
            issues = All.reportInconsistency(graph, resource, "Resource has a parent with URI but has no valid HasName.", issues);
        }
        return issues != null ? issues : Collections.emptyList();
    }

    private static Resource getPossibleNearestClusterSet(ReadGraph graph, Resource base, Resource resource) throws DatabaseException {
        ClusteringSupport cs = (ClusteringSupport)graph.getService(ClusteringSupport.class);
        if (cs.isClusterSet(resource) && !base.equals(resource)) {
            return resource;
        }
        Resource nearest = NearestOwnerFinder.getNearestOwner((ReadGraph)graph, (Resource)resource);
        if (nearest == null) {
            return null;
        }
        return All.getPossibleNearestClusterSet(graph, base, nearest);
    }

    private static boolean quirks(ReadGraph graph, Resource resource) throws DatabaseException {
        if (!resource.isPersistent()) {
            return true;
        }
        if (graph.isImmutable(resource)) {
            return true;
        }
        return resource.getResourceId() < 8192L;
    }

    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> clusterValidator(ReadGraph graph, Resource resource) throws DatabaseException {
        return Collections.emptyList();
    }

    private static boolean isInstanceOfAny(ReadGraph graph, Resource r, Collection<Resource> types, boolean ifEmpty) throws DatabaseException {
        if (types.isEmpty()) {
            return ifEmpty;
        }
        for (Resource type : types) {
            if (!graph.isInstanceOf(r, type)) continue;
            return true;
        }
        return false;
    }

    private static StringBuilder orString(ReadGraph graph, StringBuilder sb, Collection<Resource> rs) throws DatabaseException {
        sb.append("(");
        boolean first = true;
        for (Resource r : rs) {
            if (!first) {
                sb.append(" | ");
            }
            first = false;
            sb.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)r));
        }
        sb.append(")");
        return sb;
    }

    public static boolean isRelation(ReadGraph g, Layer0 l0, Resource relation) throws DatabaseException {
        return g.hasStatement(relation, l0.SubrelationOf) || relation == l0.IsWeaklyRelatedTo;
    }

    public static boolean isType(ReadGraph g, Layer0 l0, Resource type) throws DatabaseException {
        return g.hasStatement(type, l0.Inherits) || type == l0.Entity;
    }

    public static Variable buildChildVariable(ReadGraph graph, Variable context, Resource graphChild, Object nodeChild) throws DatabaseException {
        VariableBuilder builder = (VariableBuilder)graph.adapt(graphChild, VariableBuilder.class);
        return builder.buildChild(graph, context, All.build(((AbstractVariable)context).node, nodeChild), graphChild);
    }

    private static Variable buildPropertyVariable(ReadGraph graph, Variable variable, Resource parentResource, PropertyInfo graphProperty, Object propertyNode) throws DatabaseException {
        VariableNode node = variable instanceof AbstractVariable ? All.build(((AbstractVariable)variable).node, propertyNode) : null;
        return graphProperty.builder.buildProperty(graph, variable, node, parentResource, graphProperty.predicate);
    }

    static StandardGraphChildVariable createStandardGraphChildVariable(AbstractVariable parent, Object child) {
        return new StandardGraphChildVariable(parent, All.build(parent.node, child), null);
    }

    private static StandardGraphPropertyVariable createStandardGraphPropertyVariable(ReadGraph graph, AbstractVariable variable, Object nodeProperty) throws DatabaseException {
        Resource propertyResource = All.getPossiblePropertyResource(graph, variable, nodeProperty);
        return new StandardGraphPropertyVariable(graph, (Variable)variable, All.build(variable.node, nodeProperty), null, propertyResource);
    }

    static Map<String, Variable> ensureVariableMap(Map<String, Variable> map, int size) {
        if (map == null) {
            map = new THashMap(size);
        }
        return map;
    }

    private static PropertyInfo getPropertyInfo(ReadGraph graph, Resource predicate) throws DatabaseException {
        return (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(predicate));
    }

    static String getNodeName(AbstractVariable parent, Object child) {
        return parent.node.support.manager.getName(child);
    }

    private static Object getNodeValue(AbstractVariable variable, Binding binding) throws NodeManagerException, org.simantics.databoard.binding.error.BindingException {
        return variable.node.support.manager.getValue(variable.node.node, binding);
    }

    private static void setNodeValue(AbstractVariable variable, Object value, Binding binding) throws NodeManagerException, org.simantics.databoard.binding.error.BindingException {
        variable.node.support.manager.setValue(variable.node.node, value, binding);
    }

    private static String getPossiblePropertyURI(AbstractVariable parent, Object node) {
        return parent.node.support.manager.getPropertyURI(parent.node.node, node);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object defaultInstantiateUnder(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return new FunctionImpl2<Resource, Resource, Resource>(){

            public Resource apply(Resource container, Resource type) {
                try {
                    WriteGraph graph = (WriteGraph)SCLContext.getCurrent().get((Object)"graph");
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    CommonDBUtils.selectClusterSet((WriteGraph)graph, (Resource)container);
                    Resource result = graph.newResource();
                    String name = NameUtils.findFreshInstanceName((ReadGraph)graph, (Resource)type, (Resource)container);
                    graph.claim(result, L0.InstanceOf, type);
                    graph.addLiteral(result, L0.HasName, L0.NameOf, (Object)name, (Binding)Bindings.STRING);
                    graph.claim(container, L0.ConsistsOf, L0.PartOf, result);
                    return result;
                }
                catch (DatabaseException e) {
                    throw new RuntimeDatabaseException((Throwable)e);
                }
            }
        };
    }

    private static class DatatypeGetter
    implements VariableNodeReadRunnable {
        final VariableNode node;
        Datatype type;
        Exception exception;

        public DatatypeGetter(VariableNode node) {
            this.node = node;
        }

        @Override
        public void run() {
            try {
                this.type = this.node.support.manager.getDatatype(this.node.node);
            }
            catch (NodeManagerException e) {
                this.exception = e;
            }
        }

        public String toString() {
            return "DatatypeGetter(" + this.node.node + ")";
        }
    }

    static class L0Issue
    extends StandardIssue {
        private final String description;

        public L0Issue(String description, Resource type, Resource ... contexts) {
            super(type, contexts);
            this.description = description;
        }

        public Resource write(WriteGraph graph, Resource source) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            IssueResource IR = IssueResource.getInstance((ReadGraph)graph);
            Resource issue = super.write(graph, source);
            graph.claim(issue, IR.Issue_HasSeverity, IR.Severity_Fatal);
            graph.addLiteral(issue, L0.HasDescription, L0.HasDescription_Inverse, (Object)this.description, (Binding)Bindings.STRING);
            return issue;
        }
    }
}

