/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.ui.handlers;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.simantics.Simantics;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.experiment.IDynamicExperimentListener;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.experiment.IExperimentListener;
import org.simantics.simulation.experiment.SimulationTimeUtil;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.simulation.project.IExperimentManagerListener;
import org.simantics.utils.threads.ThreadUtils;

public class TimerContribution
extends CompoundContributionItem {
    private static final long LABEL_UPDATE_MIN_PERIOD_MS = 100L;
    boolean disposed = false;
    Text label;
    int width;
    double time = 0.0;
    private Mode mode = Mode.HMS;
    private ToolItem ti;
    private IExperimentManager experimentManager;
    private IExperimentManagerListener experimentManagerListener;
    private ExperimentState currentState;
    private ResourceManager resourceManager;
    private static ColorDescriptor RUNNING_BG = ColorDescriptor.createFrom((RGB)new RGB(0, 128, 0));
    private static ColorDescriptor RUNNING_FG = ColorDescriptor.createFrom((RGB)new RGB(255, 255, 255));

    public TimerContribution() {
        super("org.simantics.simulation.ui.timer");
    }

    protected IContributionItem[] getContributionItems() {
        return new IContributionItem[0];
    }

    String getTime() {
        if (this.mode == Mode.SECONDS) {
            return SimulationTimeUtil.formatSeconds((double)this.time);
        }
        return SimulationTimeUtil.formatHMSS((double)this.time);
    }

    public void fill(ToolBar parent, int index) {
        IProject project = Simantics.peekProject();
        if (project == null) {
            return;
        }
        IExperimentManager manager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (manager == null) {
            return;
        }
        IExperiment active = manager.getActiveExperiment();
        if (!(active instanceof IDynamicExperiment)) {
            return;
        }
        this.ti = new ToolItem(parent, 2, index);
        this.ti.setText("Simulation Timer");
        this.ti.setToolTipText("Simulation Timer");
        this.label = new Text((Composite)parent, 0x1000808);
        this.label.setText(this.getTime());
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.label);
        this.updateTooltip();
        Listener labelListener = new Listener(){
            boolean pressed = false;
            boolean inside = false;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        if (!this.inside || event.button != 1 && event.button != 2) break;
                        this.pressed = true;
                        break;
                    }
                    case 4: {
                        if (!this.pressed || !this.inside) break;
                        this.pressed = false;
                        TimerContribution.this.toggleMode();
                        break;
                    }
                    case 6: {
                        this.inside = true;
                        break;
                    }
                    case 7: {
                        this.inside = false;
                    }
                }
            }
        };
        this.label.addListener(3, labelListener);
        this.label.addListener(6, labelListener);
        this.label.addListener(7, labelListener);
        this.label.addListener(4, labelListener);
        this.width = this.label.computeSize((int)-1, (int)-1, (boolean)true).x;
        this.ti.setWidth(this.width);
        this.ti.setControl((Control)this.label);
        if (this.currentState != null) {
            this.setLabelVisualsByState(this.currentState);
        }
        this.attachToExperimentManager(manager);
    }

    private void attachToExperimentManager(final IExperimentManager manager) {
        if (this.experimentManager != null) {
            if (this.experimentManager.equals(manager)) {
                return;
            }
            this.experimentManager.removeListener(this.experimentManagerListener);
        }
        if (manager == null) {
            return;
        }
        this.experimentManagerListener = new IExperimentManagerListener(){
            IDynamicExperiment currentExperiment;
            IExperimentListener currentListener;

            public void managerDisposed() {
                manager.removeListener((IExperimentManagerListener)this);
            }

            public void activeExperimentUnloaded() {
                this.attachToExperiment(null);
            }

            public void activeExperimentLoaded(IExperiment experiment) {
                this.attachToExperiment(experiment);
            }

            synchronized void attachToExperiment(final IExperiment experiment) {
                if (this.currentExperiment != null) {
                    this.currentExperiment.removeListener(this.currentListener);
                    this.currentExperiment = null;
                    this.currentListener = null;
                }
                if (experiment == null) {
                    return;
                }
                if (!(experiment instanceof IDynamicExperiment)) {
                    return;
                }
                IDynamicExperiment dynExp = (IDynamicExperiment)experiment;
                IDynamicExperimentListener listener = new IDynamicExperimentListener(){
                    final IExperimentListener _this = this;
                    long lastUpdateTime = 0L;
                    ScheduledFuture<?> timedUpdate = null;
                    ExperimentState lastState = null;

                    public void timeChanged(double newTime) {
                        (this).TimerContribution.this.time = newTime;
                        ScheduledFuture<?> f = this.timedUpdate;
                        if (f != null && !f.isDone()) {
                            return;
                        }
                        long timeSinceLastUpdate = System.currentTimeMillis() - this.lastUpdateTime;
                        if (timeSinceLastUpdate > 100L) {
                            this.scheduleLabelUpdate();
                        } else {
                            this.timedUpdate = ThreadUtils.getNonBlockingWorkExecutor().schedule(new Runnable(){

                                @Override
                                public void run() {
                                    this.scheduleLabelUpdate();
                                }
                            }, 100L - timeSinceLastUpdate, TimeUnit.MILLISECONDS);
                        }
                    }

                    private void scheduleLabelUpdate() {
                        this.lastUpdateTime = System.currentTimeMillis();
                        this.timedUpdate = null;
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!((this).this).TimerContribution.this.label.isDisposed()) {
                                    TimerContribution.this.updateLabel();
                                }
                                if (lastState != TimerContribution.this.currentState) {
                                    TimerContribution.this.setLabelVisualsByState(TimerContribution.this.currentState);
                                    lastState = TimerContribution.this.currentState;
                                }
                            }
                        });
                    }

                    public void stateChanged(ExperimentState state) {
                        TimerContribution.this.currentState = state;
                        if (state == ExperimentState.DISPOSED) {
                            experiment.removeListener(this._this);
                        } else {
                            this.scheduleLabelUpdate();
                        }
                    }
                };
                experiment.addListener((IExperimentListener)listener);
                this.currentExperiment = dynExp;
                this.currentListener = listener;
            }
        };
        this.experimentManager = manager;
        manager.addListener(this.experimentManagerListener);
    }

    private void toggleMode() {
        this.mode = this.mode.next();
        if (this.label.isDisposed()) {
            return;
        }
        this.updateLabel();
        this.updateTooltip();
    }

    private void updateTooltip() {
        if (this.label.isDisposed()) {
            return;
        }
        switch (this.mode) {
            case HMS: {
                this.label.setToolTipText("Shows simulation time in HMS");
                break;
            }
            case SECONDS: {
                this.label.setToolTipText("Shows simulation time in seconds");
            }
        }
    }

    private void updateLabel() {
        Point selection = this.label.getSelection();
        String oldText = this.label.getText();
        String newText = this.getTime();
        selection.y = selection.y == oldText.length() ? newText.length() : Math.min(selection.y, newText.length());
        this.label.setText(newText);
        this.label.setSelection(selection);
        int newWidth = this.label.computeSize((int)-1, (int)-1, (boolean)true).x;
        if (newWidth != this.width) {
            this.label.pack();
            this.width = newWidth;
            if (!this.ti.isDisposed()) {
                this.ti.setWidth(this.width);
                if (!this.ti.getParent().isDisposed()) {
                    this.ti.getParent().pack();
                }
            }
        }
    }

    public void dispose() {
        this.disposed = true;
        this.attachToExperimentManager(null);
    }

    public boolean isDynamic() {
        return true;
    }

    private void setLabelVisualsByState(ExperimentState currentState) {
        if (this.label.isDisposed()) {
            return;
        }
        switch (currentState) {
            case RUNNING: {
                this.label.setBackground((Color)this.resourceManager.get((DeviceResourceDescriptor)RUNNING_BG));
                this.label.setForeground((Color)this.resourceManager.get((DeviceResourceDescriptor)RUNNING_FG));
                this.label.setEnabled(true);
                break;
            }
            case STOPPED: {
                this.label.setBackground(null);
                this.label.setForeground(null);
                this.label.setFont(null);
                this.label.setEnabled(true);
                break;
            }
            case INITIALIZING: {
                this.label.setBackground(null);
                this.label.setForeground(null);
                this.label.setFont(null);
                this.label.setEnabled(false);
            }
        }
    }

    static enum Mode {
        HMS,
        SECONDS;


        Mode next() {
            switch (this) {
                case HMS: {
                    return SECONDS;
                }
                case SECONDS: {
                    return HMS;
                }
            }
            return HMS;
        }
    }
}

