/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.types;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.constants.generic.ClassRef;
import org.simantics.scl.compiler.internal.codegen.types.JavaReferenceValidator;
import org.simantics.scl.runtime.function.Function;

public abstract class AbstractRuntimeJavaReferenceValidator
implements JavaReferenceValidator<Class<?>, Method, Field, Constructor<?>> {
    @Override
    public abstract Class<?> findClass(TypeDesc var1);

    @Override
    public boolean isInterface(Class<?> clazz) {
        return clazz.isInterface();
    }

    @Override
    public boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public Method[] findCompatibleMethods(Class<?> clazz, boolean isStatic, String name, TypeDesc[] parameterTypes, TypeDesc returnType) {
        Class[] parameterClasses = new Class[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            parameterClasses[i] = this.findClass(parameterTypes[i]);
            ++i;
        }
        Object returnClass = this.findClass(returnType);
        ArrayList<Method> methods = new ArrayList<Method>(2);
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                Class<?>[] parameters;
                Method method = methodArray[n2];
                if (method.getName().equals(name) && Modifier.isStatic(method.getModifiers()) == isStatic && (parameters = method.getParameterTypes()).length == parameterClasses.length) {
                    int i2 = 0;
                    while (i2 < parameters.length) {
                        if (parameters[i2].isAssignableFrom(parameterClasses[i2])) {
                            ++i2;
                            continue;
                        }
                        break block6;
                    }
                    if (((Class)returnClass).isAssignableFrom(method.getReturnType())) {
                        methods.add(method);
                    }
                }
            }
            ++n2;
        }
        return methods.toArray(new Method[methods.size()]);
    }

    @Override
    public TypeDesc getReturnType(Method method) {
        return TypeDesc.forClass(method.getReturnType());
    }

    @Override
    public TypeDesc[] getParameterTypes(Method method) {
        Class<?>[] parameters = method.getParameterTypes();
        TypeDesc[] result = new TypeDesc[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            result[i] = TypeDesc.forClass(parameters[i]);
            ++i;
        }
        return result;
    }

    public Constructor<?>[] findCompatibleConstructors(Class<?> clazz, TypeDesc[] types) {
        Class[] classes = new Class[types.length];
        int i = 0;
        while (i < types.length) {
            classes[i] = this.findClass(types[i]);
            ++i;
        }
        int maxArity = types.length - 1;
        ArrayList constructors = new ArrayList(2);
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                Constructor<?> constructor = constructorArray[n2];
                Class<?>[] parameters = constructor.getParameterTypes();
                int arity = parameters.length;
                if (arity <= maxArity) {
                    int i2 = 0;
                    while (i2 < parameters.length) {
                        if (parameters[i2].isAssignableFrom(classes[i2])) {
                            ++i2;
                            continue;
                        }
                        break block6;
                    }
                    if (!(arity == maxArity ? !classes[maxArity].isAssignableFrom(clazz) : !Function.class.isAssignableFrom(clazz))) {
                        constructors.add(constructor);
                    }
                }
            }
            ++n2;
        }
        return constructors.toArray(new Constructor[constructors.size()]);
    }

    @Override
    public TypeDesc[] getConstructorParameterTypes(Constructor<?> constructor) {
        Class<?>[] parameters = constructor.getParameterTypes();
        TypeDesc[] result = new TypeDesc[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            result[i] = TypeDesc.forClass(parameters[i]);
            ++i;
        }
        return result;
    }

    @Override
    public Field findField(Class<?> clazz, String name) {
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    @Override
    public boolean isStaticField(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    @Override
    public TypeDesc getFieldType(Field field) {
        return TypeDesc.forClass(field.getType());
    }

    @Override
    public boolean isAssignableFrom(TypeDesc to, TypeDesc from) {
        if (to.equals(from) || to.equals(TypeDesc.OBJECT)) {
            return true;
        }
        Object toClass = this.findClass(to);
        Object fromClass = this.findClass(from);
        if (toClass == null || fromClass == null) {
            return false;
        }
        return ((Class)toClass).isAssignableFrom((Class<?>)fromClass);
    }

    public Method[] chooseBest(Method[] methods) {
        ArrayList<Method> newResult = new ArrayList<Method>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (!method.isSynthetic()) {
                newResult.add(method);
            }
            ++n2;
        }
        return newResult.toArray(new Method[newResult.size()]);
    }

    @Override
    public ClassRef getClassRef(String className) {
        Object clazz = this.findClass(TypeDesc.forClass(className));
        if (clazz == null) {
            return null;
        }
        return new ClassRef((Class<?>)clazz);
    }
}

