/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.internal;

import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.simantics.issues.Severity;
import org.simantics.message.IMessageSchemeManager;
import org.simantics.utils.ui.gfx.AlphaAdjustmentImageDescriptor;
import org.simantics.utils.ui.gfx.HSVAdjustmentImageDescriptor;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.simantics.issues.ui";
    static Activator instance;
    ServiceTracker messageScheme;
    public static ImageDescriptor HIDE_ICON;
    public static ImageDescriptor UNHIDE_ICON;
    public static ImageDescriptor RESOLVE_ICON;
    public static ImageDescriptor UNRESOLVE_ICON;
    public static ImageDescriptor PURGE_ICON;
    public static ImageDescriptor FATAL_ICON;
    public static ImageDescriptor ERROR_ICON;
    public static ImageDescriptor WARNING_ICON;
    public static ImageDescriptor INFO_ICON;
    public static ImageDescriptor NOTE_ICON;
    public static ImageDescriptor OK_ICON;
    public static ImageDescriptor FATAL_DECORATION_ICON;
    public static ImageDescriptor ERROR_DECORATION_ICON;
    public static ImageDescriptor WARNING_DECORATION_ICON;
    public static ImageDescriptor INFO_DECORATION_ICON;
    public static ImageDescriptor NOTE_DECORATION_ICON;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.messageScheme = new ServiceTracker(context, IMessageSchemeManager.class.getName(), null);
        Bundle bundle = context.getBundle();
        HIDE_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/hide.png"));
        UNHIDE_ICON = AlphaAdjustmentImageDescriptor.adjustAlpha((ImageDescriptor)HSVAdjustmentImageDescriptor.adjust((ImageDescriptor)HIDE_ICON, (float)0.0f, (float)0.0f, (float)1.0f), (int)96);
        RESOLVE_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/tick.png"));
        UNRESOLVE_ICON = AlphaAdjustmentImageDescriptor.adjustAlpha((ImageDescriptor)HSVAdjustmentImageDescriptor.adjust((ImageDescriptor)RESOLVE_ICON, (float)0.0f, (float)0.0f, (float)1.0f), (int)96);
        PURGE_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/purge.gif"));
        FATAL_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/fatal.png"));
        ERROR_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/error.png"));
        WARNING_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/warning.png"));
        INFO_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/information.png"));
        NOTE_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/note.png"));
        OK_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/noissue.png"));
        FATAL_DECORATION_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/fatal_decoration.png"));
        ERROR_DECORATION_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/error_decoration.png"));
        WARNING_DECORATION_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/warning_decoration.png"));
        INFO_DECORATION_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/information_decoration.png"));
        NOTE_DECORATION_ICON = ImageDescriptor.createFromURL((URL)bundle.getResource("icons/note_decoration.png"));
    }

    protected ImageRegistry createImageRegistry() {
        return super.createImageRegistry();
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(String.valueOf(Severity.FATAL.toString()) + "-full", FATAL_ICON);
        reg.put(String.valueOf(Severity.ERROR.toString()) + "-full", ERROR_ICON);
        reg.put(String.valueOf(Severity.WARNING.toString()) + "-full", WARNING_ICON);
        reg.put(String.valueOf(Severity.INFO.toString()) + "-full", INFO_ICON);
        reg.put(String.valueOf(Severity.NOTE.toString()) + "-full", NOTE_ICON);
        reg.put(Severity.FATAL.toString(), FATAL_DECORATION_ICON);
        reg.put(Severity.ERROR.toString(), ERROR_DECORATION_ICON);
        reg.put(Severity.WARNING.toString(), WARNING_DECORATION_ICON);
        reg.put(Severity.INFO.toString(), INFO_DECORATION_ICON);
        reg.put(Severity.NOTE.toString(), NOTE_DECORATION_ICON);
    }

    public void stop(BundleContext context) throws Exception {
        this.messageScheme.close();
        instance = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return instance;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static URL getDefaultResource(String name) {
        Activator plugin = Activator.getDefault();
        if (plugin == null) {
            throw new IllegalStateException("The plugin is not active.");
        }
        Bundle bundle = plugin.getBundle();
        return bundle.getResource(name);
    }
}

