/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.extension.internal;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.common.extension.internal.ContributorExtension;
import org.simantics.browsing.ui.common.extension.internal.ContributorExtensionImpl;
import org.simantics.browsing.ui.content.Contributor;
import org.simantics.utils.strings.StringUtils;

public abstract class ContributorExtensionManager<Factory>
implements IExtensionChangeHandler {
    private static final String NAMESPACE = "org.simantics.browsing.ui.common";
    private ExtensionTracker tracker;
    ContributorExtension<Factory>[] extensions = new ContributorExtension[0];

    public abstract String getExtensionPointName();

    ContributorExtensionManager() {
        this.tracker = new ExtensionTracker();
        IExtensionPoint expt = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE, this.getExtensionPointName());
        this.loadExtensions(expt.getConfigurationElements());
        IFilter filter = ExtensionTracker.createExtensionPointFilter((IExtensionPoint)expt);
        this.tracker.registerHandler((IExtensionChangeHandler)this, filter);
    }

    void close() {
        this.tracker.close();
        this.tracker = null;
        this.extensions = new ContributorExtension[0];
    }

    public ContributorExtension<Factory>[] getExtensions() {
        return this.extensions;
    }

    private void loadExtensions(IConfigurationElement[] elements) {
        HashSet<ContributorExtension<Factory>> newExtensions = new HashSet<ContributorExtension<Factory>>(Arrays.asList(this.extensions));
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            try {
                String id = StringUtils.safeString((String)el.getAttribute("id"));
                Contributor factory = (Contributor)el.createExecutableExtension("class");
                ContributorExtensionImpl ext = new ContributorExtensionImpl(id, factory);
                this.tracker.registerObject(el.getDeclaringExtension(), ext, 0);
                newExtensions.add(ext);
            }
            catch (CoreException e) {
                ErrorLogger.defaultLogError("Failed to initialize " + this.getExtensionPointName() + " extension \"" + el.getName() + "\" with name \"" + el.getAttribute("name") + "\": " + e.getMessage(), e);
            }
            ++n2;
        }
        this.extensions = newExtensions.toArray(new ContributorExtension[newExtensions.size()]);
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        this.loadExtensions(extension.getConfigurationElements());
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        HashSet<ContributorExtension<Factory>> newExtensions = new HashSet<ContributorExtension<Factory>>(Arrays.asList(this.extensions));
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.tracker.unregisterObject(extension, o);
            newExtensions.remove(o);
            ++n2;
        }
        this.extensions = newExtensions.toArray(new ContributorExtension[newExtensions.size()]);
    }
}

