/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes.spatial;

import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.rtree.RTree;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntProcedure;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.INodeEventHandlerProvider;
import org.simantics.scenegraph.g2d.events.NodeEventHandler;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;

public class RTreeNode
extends G2DParentNode
implements INodeEventHandlerProvider {
    private static final boolean DISABLE_RTREE = false;
    private static final boolean DEBUG_SHRINK_CLIP_RECT = false;
    private static final long serialVersionUID = 8988645670981494042L;
    private volatile transient Tree tree = null;
    private transient ArrayList<IG2DNode> collected = new ArrayList();
    private transient Set<IG2DNode> simplified = new HashSet<IG2DNode>();
    Properties props = new Properties();

    @Override
    protected Map<String, INode> createChildMap() {
        return super.createChildMap(32768);
    }

    @Override
    public void render(Graphics2D g) {
        AffineTransform ot = null;
        if (!this.transform.isIdentity()) {
            ot = g.getTransform();
            g.transform(this.transform);
        }
        g.setRenderingHint(G2DRenderingHints.KEY_TRANSFORM_UNDER_SPATIAL_ROOT, g.getTransform());
        try {
            Shape clipShape = g.getClip();
            Rectangle2D bounds = null;
            if (clipShape instanceof Rectangle2D) {
                bounds = (Rectangle2D)clipShape;
            } else if (clipShape != null) {
                bounds = clipShape.getBounds2D();
            }
            double viewScale = GeometryUtils.getScale(g.getTransform());
            if (Math.abs(viewScale) <= Double.MIN_VALUE) {
                return;
            }
            final double unitsPerPixel = 1.0 / viewScale;
            if (bounds != null) {
                GeometryUtils.expandRectangle(bounds, 5.0);
            }
            final Tree tree = this.getSpatialDecomposition();
            if (bounds == null || tree.bounds == null || RTreeNode.containedBy(tree.bounds, bounds)) {
                IG2DNode[] iG2DNodeArray = this.getSortedNodes();
                int n = iG2DNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IG2DNode node = iG2DNodeArray[n2];
                    if (node.validate()) {
                        node.render(g);
                    }
                    ++n2;
                }
            } else {
                final Object render = g.getRenderingHint(RenderingHints.KEY_RENDERING);
                this.collected.clear();
                if (tree.boundlessNodes != null) {
                    int i = 0;
                    int n = tree.boundlessNodes.size();
                    while (i < n) {
                        this.collected.add(tree.boundlessNodes.get(i));
                        ++i;
                    }
                }
                tree.rtree.intersects(RTreeNode.toRectangle(bounds), new TIntProcedure(){

                    @Override
                    public boolean execute(int value) {
                        IG2DNode node = tree.toNodes.get(value);
                        if (node == null || !node.validate()) {
                            return true;
                        }
                        if (render != RenderingHints.VALUE_RENDER_QUALITY) {
                            Rectangle2D r = tree.toBounds.get(value);
                            if (r == null) {
                                return true;
                            }
                            double w = r.getWidth();
                            double h = r.getHeight();
                            if (w < unitsPerPixel && h < unitsPerPixel) {
                                return true;
                            }
                        }
                        RTreeNode.this.collected.add(node);
                        return true;
                    }
                });
                Collections.sort(this.collected, G2DParentNode.G2DNODE_Z_COMPARATOR);
                if (this.simplified.isEmpty()) {
                    for (IG2DNode node : this.collected) {
                        if (!node.validate()) continue;
                        node.render(g);
                    }
                } else {
                    for (IG2DNode node : this.collected) {
                        if (!node.validate()) continue;
                        if (this.simplified.contains(node)) {
                            g.draw(node.getBoundsInLocal());
                            continue;
                        }
                        node.render(g);
                    }
                    this.simplified.clear();
                }
            }
        }
        finally {
            g.setRenderingHint(G2DRenderingHints.KEY_TRANSFORM_UNDER_SPATIAL_ROOT, null);
            if (ot != null) {
                g.setTransform(ot);
            }
        }
    }

    @INode.ClientSide
    public void setDirty() {
        this.tree = null;
    }

    private Tree getSpatialDecomposition() {
        Tree t = this.tree;
        if (t == null) {
            this.tree = t = this.decompose();
        }
        return t;
    }

    private Tree decompose() {
        RTree rtree = new RTree();
        rtree.init(this.props);
        IG2DNode[] nodes = this.getSortedNodes();
        TIntObjectHashMap<IG2DNode> toNodes = new TIntObjectHashMap<IG2DNode>(nodes.length);
        TIntObjectHashMap<Rectangle2D> toBounds = new TIntObjectHashMap<Rectangle2D>(nodes.length);
        int rid = 0;
        ArrayList<IG2DNode> boundlessNodes = null;
        IG2DNode[] iG2DNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IG2DNode node = iG2DNodeArray[n2];
            Rectangle2D bounds = node.getBounds();
            if (bounds != null) {
                Rectangle r = RTreeNode.toRectangle(bounds);
                int id = ++rid;
                rtree.add(r, id);
                toNodes.put(id, node);
                toBounds.put(id, bounds);
            } else {
                if (boundlessNodes == null) {
                    boundlessNodes = new ArrayList<IG2DNode>();
                }
                boundlessNodes.add(node);
            }
            ++n2;
        }
        return new Tree(rtree, boundlessNodes, toNodes, toBounds);
    }

    public static Rectangle toRectangle(Rectangle2D rect) {
        return new Rectangle((float)rect.getMinX(), (float)rect.getMinY(), (float)rect.getMaxX(), (float)rect.getMaxY());
    }

    public List<IG2DNode> intersectingNodes(Rectangle2D rect, List<IG2DNode> result) {
        Tree tree = this.getSpatialDecomposition();
        if (rect == null || tree.bounds == null || RTreeNode.containedBy(tree.bounds, rect)) {
            IG2DNode[] nodes;
            IG2DNode[] iG2DNodeArray = nodes = this.getSortedNodes();
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                IG2DNode node = iG2DNodeArray[n2];
                if (node.validate()) {
                    result.add(node);
                }
                ++n2;
            }
        } else {
            tree.rtree.intersects(RTreeNode.toRectangle(rect), value -> {
                IG2DNode node = tree.toNodes.get(value);
                if (node == null || !node.validate()) {
                    return true;
                }
                result.add(node);
                return true;
            });
        }
        Collections.sort(result, G2DParentNode.G2DNODE_Z_COMPARATOR);
        return result;
    }

    public static boolean containedBy(Rectangle contained, Rectangle2D container) {
        return container.getMaxX() >= (double)contained.maxX && container.getMinX() <= (double)contained.minX && container.getMaxY() >= (double)contained.maxY && container.getMinY() <= (double)contained.minY;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    @Override
    public int getEventMask() {
        return EventTypes.MouseMask;
    }

    @Override
    public boolean handleEvent(Event e) {
        return false;
    }

    @Override
    public NodeEventHandler getEventHandler() {
        return NodeUtil.getNodeEventHandler(this);
    }

    private static class Tree {
        public final RTree rtree;
        public final Rectangle bounds;
        public final ArrayList<IG2DNode> boundlessNodes;
        public final TIntObjectHashMap<IG2DNode> toNodes;
        public final TIntObjectHashMap<Rectangle2D> toBounds;

        public Tree(RTree rtree, ArrayList<IG2DNode> boundlessNodes, TIntObjectHashMap<IG2DNode> toNodes, TIntObjectHashMap<Rectangle2D> toBounds) {
            this.rtree = rtree;
            this.bounds = rtree.getBounds();
            this.boundlessNodes = boundlessNodes;
            this.toNodes = toNodes;
            this.toBounds = toBounds;
        }
    }
}

