/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.browser;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.module.repository.ModuleRepositories;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.Activator;
import org.simantics.scl.ui.browser.Messages;

public class SCLDefinitionSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "SCLDefinitionSelectionDialogSettings";

    public SCLDefinitionSelectionDialog(Shell shell) {
        super(shell, false);
        this.setTitle(Messages.SCLDefinitionSelectionDialog_ChooseSCLDefinition);
        this.setSelectionHistory(new DefinitionSelectionHistory());
        this.setListLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    return (String)element;
                }
                SCLValue value = (SCLValue)element;
                if (element == null) {
                    return "";
                }
                Name name = value.getName();
                return String.valueOf(name.name) + " (" + name.module + ") :: " + value.getType();
            }
        });
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getInstance().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = Activator.getInstance().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){
            {
                String patternText = this.getPattern();
                this.patternMatcher = new SearchPattern();
                if (patternText != null && patternText.length() > 0) {
                    this.patternMatcher.setPattern(patternText);
                } else {
                    this.patternMatcher.setPattern("*");
                }
            }

            public boolean matchItem(Object item) {
                String text = item.toString();
                if (this.getPattern().contains("/")) {
                    return this.matches(text);
                }
                int p = text.lastIndexOf(47);
                if (p >= 0) {
                    text = text.substring(p + 1);
                }
                return this.matches(text);
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }
        };
    }

    protected Comparator getItemsComparator() {
        return new Comparator(){

            public int compare(Object arg0, Object arg1) {
                SCLValue a = (SCLValue)arg0;
                SCLValue b = (SCLValue)arg1;
                int cmp = a.getName().name.compareTo(b.getName().name);
                if (cmp != 0) {
                    return cmp;
                }
                return a.getName().module.compareTo(b.getName().module);
            }
        };
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.beginTask("Searching", 1);
        for (SCLValue value : ModuleRepositories.allValues((ModuleRepository)SCLOsgi.MODULE_REPOSITORY)) {
            if (this.isTupleValue(value.getName())) continue;
            contentProvider.add((Object)value, itemsFilter);
        }
        progressMonitor.worked(1);
        progressMonitor.done();
    }

    private boolean isTupleValue(Name name) {
        return name.module.equals("Builtin") && name.name.startsWith("(") && (name.name.equals("()") || name.name.charAt(1) == ',');
    }

    public String getElementName(Object item) {
        return item.toString();
    }

    private class DefinitionSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private DefinitionSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento element) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento element) {
        }
    }
}

