/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.JTableHeader;
import org.simantics.spreadsheet.ui.TableBorder;

public class RowHeaderRenderer
implements ListCellRenderer {
    private static Color ROW_HEADER_BACKGROUND = new Color(240, 240, 240);
    final Map<Integer, JLabel> labels = new HashMap<Integer, JLabel>();
    final JTable table;
    final JTableHeader header;

    RowHeaderRenderer(JTable table) {
        this.header = table.getTableHeader();
        this.table = table;
    }

    private JLabel newLabel() {
        JLabel label = new JLabel();
        label.setOpaque(true);
        label.setBorder(TableBorder.BORDER);
        label.setHorizontalAlignment(0);
        label.setForeground(this.header.getForeground());
        label.setBackground(ROW_HEADER_BACKGROUND);
        label.setFont(this.header.getFont());
        return label;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = this.labels.get(index);
        if (label == null) {
            label = this.newLabel();
            this.labels.put(index, label);
        }
        label.setText(value == null ? "" : value.toString());
        int height = this.table.getRowHeight(index);
        label.setPreferredSize(new Dimension(label.getWidth(), height));
        return label;
    }
}

