/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.property.PropertyComparable;
import org.simantics.browsing.ui.common.property.PropertyComparator;
import org.simantics.browsing.ui.swt.DefaultIsExpandedProcessor;
import org.simantics.utils.ui.AdaptionUtils;

public class PropertyIsExpandedProcessor
extends DefaultIsExpandedProcessor {
    private static final boolean DEBUG = false;
    private final Set<PropertyComparable> expandedProperties = new TreeSet<PropertyComparable>((Comparator<PropertyComparable>)PropertyComparator.INSTANCE);
    private final Map<PropertyComparable, PrimitiveQueryUpdater> expandedPropertyQueries = new TreeMap<PropertyComparable, PrimitiveQueryUpdater>((Comparator<PropertyComparable>)PropertyComparator.INSTANCE);

    @Override
    public String toString() {
        return "PropertyIsExpandedProcessor";
    }

    private PropertyComparable getProperty(NodeContext context) {
        return (PropertyComparable)AdaptionUtils.adaptToSingle((Object)context, PropertyComparable.class);
    }

    @Override
    public boolean setExpanded(NodeContext context, boolean expanded) {
        PropertyComparable prop = this.getProperty(context);
        if (prop != null) {
            return this._setExpanded(prop, expanded);
        }
        return super.setExpanded(context, expanded);
    }

    private boolean _setExpanded(PropertyComparable prop, boolean expanded) {
        if (expanded) {
            return this.expandedProperties.add(prop);
        }
        return this.expandedProperties.remove(prop);
    }

    @Override
    public Boolean query(PrimitiveQueryUpdater updater, NodeContext context, NodeContext.PrimitiveQueryKey<Boolean> key) {
        PropertyComparable prop = this.getProperty(context);
        if (prop != null) {
            boolean isExpanded = this.expandedProperties.contains(prop);
            this.expandedPropertyQueries.put(prop, updater);
            return isExpanded;
        }
        return super.query(updater, context, (NodeContext.PrimitiveQueryKey)key);
    }

    @Override
    protected boolean nodeStatusChanged(NodeContext context, boolean expanded) {
        boolean result = false;
        PropertyComparable prop = this.getProperty(context);
        if (prop != null) {
            result = this._setExpanded(prop, expanded);
            PrimitiveQueryUpdater updater = this.expandedPropertyQueries.get(prop);
            if (updater != null) {
                updater.scheduleReplace(context, BuiltinKeys.IS_EXPANDED, (Object)expanded);
            }
        } else {
            result = super.nodeStatusChanged(context, expanded);
        }
        return result;
    }

    @Override
    public void clear() {
        this.expandedProperties.clear();
        this.expandedPropertyQueries.clear();
        super.clear();
    }
}

